/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.TimeoutUtil;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class BaseDataReader {
    private static final Logger LOG = Logger.getInstance(BaseDataReader.class);
    protected volatile boolean isStopped = false;
    private Future<?> myFinishedFuture = null;
    protected final SleepingPolicy mySleepingPolicy;

    public BaseDataReader(SleepingPolicy sleepingPolicy) {
        this.mySleepingPolicy = sleepingPolicy != null ? sleepingPolicy : SleepingPolicy.SIMPLE;
    }

    protected void start() {
        if (this.myFinishedFuture == null) {
            this.myFinishedFuture = this.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    BaseDataReader.this.doRun();
                }
            });
        }
    }

    protected abstract Future<?> executeOnPooledThread(Runnable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() {
        try {
            while (true) {
                boolean read = this.readAvailable();
                if (this.isStopped) {
                    break;
                }
                TimeoutUtil.sleep(this.mySleepingPolicy.getTimeToSleep(read));
            }
        }
        catch (IOException e) {
            LOG.info(e);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.error("Can't close stream", e);
            }
        }
    }

    protected abstract boolean readAvailable() throws IOException;

    protected abstract void close() throws IOException;

    public void stop() {
        this.isStopped = true;
    }

    public void waitFor() throws InterruptedException {
        try {
            this.myFinishedFuture.get();
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
    }

    public static class AdaptiveSleepingPolicy
    implements SleepingPolicy {
        private static final int maxSleepTimeWhenIdle = 200;
        private static final int maxIterationsWithCurrentSleepTime = 50;
        private volatile int myIterationsWithCurrentTime;
        private volatile int myCurrentSleepTime = 5;

        @Override
        public int getTimeToSleep(boolean wasActive) {
            int iterationsWithCurrentTime;
            int currentSleepTime = this.myCurrentSleepTime;
            if (wasActive) {
                currentSleepTime = 1;
            } else if (currentSleepTime == 1) {
                currentSleepTime = 5;
                this.myIterationsWithCurrentTime = 0;
            } else if ((iterationsWithCurrentTime = ++this.myIterationsWithCurrentTime) >= 50) {
                this.myIterationsWithCurrentTime = 0;
                currentSleepTime = Math.min(2 * currentSleepTime, 200);
            }
            this.myCurrentSleepTime = currentSleepTime;
            return currentSleepTime;
        }
    }

    public static interface SleepingPolicy {
        public static final int sleepTimeWhenWasActive = 1;
        public static final int sleepTimeWhenIdle = 5;
        public static final SleepingPolicy SIMPLE = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return wasActive ? 1 : 5;
            }
        };
        public static final SleepingPolicy BLOCKING = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return 50;
            }
        };

        public int getTimeToSleep(boolean var1);
    }
}

