/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ByteBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public abstract class DirectBufferWrapper
extends ByteBufferWrapper {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.DirectBufferWrapper");
    private volatile ByteBuffer myBuffer;

    protected DirectBufferWrapper(File file, long offset, long length) {
        super(file, offset, length);
    }

    @Override
    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    @Override
    public ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = this.create();
        }
        return buffer;
    }

    protected abstract ByteBuffer create() throws IOException;

    @Override
    public void unmap() {
        if (this.isDirty()) {
            this.flush();
        }
        if (this.myBuffer != null) {
            DirectBufferWrapper.disposeDirectBuffer((DirectBuffer)((Object)this.myBuffer));
        }
        this.myBuffer = null;
    }

    static boolean disposeDirectBuffer(final DirectBuffer buffer) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Cleaner cleaner = buffer.cleaner();
                    if (cleaner != null) {
                        cleaner.clean();
                    }
                    return null;
                }
                catch (Exception e) {
                    return buffer;
                }
            }
        }) == null;
    }
}

