/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PagedFileStorage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class ResizeableMappedFile
implements Forceable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.ResizeableMappedFile");
    private long myLogicalSize;
    private final PagedFileStorage myStorage;

    public ResizeableMappedFile(File file, int initialSize, PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        this(file, initialSize, lockContext, pageSize, valuesAreBufferAligned, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResizeableMappedFile(File file, int initialSize, PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) throws IOException {
        this.myStorage = new PagedFileStorage(file, lockContext, pageSize, valuesAreBufferAligned, nativeBytesOrder);
        boolean exists = file.exists();
        if (!exists || file.length() == 0L) {
            if (!exists) {
                FileUtil.createParentDirs(file);
            }
            this.writeLength(0L);
        }
        this.myLogicalSize = this.readLength();
        if (this.myLogicalSize == 0L) {
            try {
                this.getPagedFileStorage().lock();
                this.myStorage.resize(initialSize);
            }
            finally {
                this.getPagedFileStorage().unlock();
            }
        }
    }

    public ResizeableMappedFile(File file, int initialSize, PagedFileStorage.StorageLock lock, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        this(file, initialSize, lock.myDefaultStorageLockContext, pageSize, valuesAreBufferAligned);
    }

    public ResizeableMappedFile(File file, int initialSize, PagedFileStorage.StorageLock lock) throws IOException {
        this(file, initialSize, lock, -1, false);
    }

    public long length() {
        return this.myLogicalSize;
    }

    private long realSize() {
        return this.myStorage.length();
    }

    private void resize(long size) {
        try {
            this.myStorage.resize(size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void ensureSize(long pos) {
        if (pos + 16L > Integer.MAX_VALUE) {
            throw new RuntimeException("FATAL ERROR: Can't get over 2^32 address space");
        }
        this.myLogicalSize = Math.max(pos, this.myLogicalSize);
        while (pos >= this.realSize()) {
            this.expand();
        }
    }

    private void expand() {
        long newSize = Math.min(Integer.MAX_VALUE, (this.realSize() + 1L) * 13L >> 3);
        this.resize((int)newSize);
    }

    private File getLengthFile() {
        return new File(this.myStorage.getFile().getPath() + ".len");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLength(long len) {
        final File lengthFile = this.getLengthFile();
        FilterOutputStream stream = null;
        try {
            stream = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<DataOutputStream, FileNotFoundException>(){

                @Override
                public DataOutputStream execute(boolean lastAttempt) throws FileNotFoundException {
                    try {
                        return new DataOutputStream(new FileOutputStream(lengthFile));
                    }
                    catch (FileNotFoundException ex) {
                        if (!lastAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
            if (stream != null) {
                ((java.io.DataOutputStream)stream).writeLong(len);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.myStorage.isDirty();
    }

    @Override
    public void force() {
        if (this.isDirty()) {
            this.writeLength(this.myLogicalSize);
        }
        this.myStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLength() {
        File lengthFile = this.getLengthFile();
        FilterInputStream stream = null;
        try {
            stream = new DataInputStream(new FileInputStream(lengthFile));
            long l = ((DataInputStream)stream).readLong();
            return l;
        }
        catch (IOException e) {
            this.writeLength(this.realSize());
            long l = this.realSize();
            return l;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    public int getInt(long index) {
        return this.myStorage.getInt(index);
    }

    public void putInt(long index, int value) {
        this.ensureSize(index + 4L);
        this.myStorage.putInt(index, value);
    }

    public short getShort(long index) {
        return this.myStorage.getShort(index);
    }

    public void putShort(long index, short value) {
        this.ensureSize(index + 2L);
        this.myStorage.putShort(index, value);
    }

    public long getLong(long index) {
        return this.myStorage.getLong(index);
    }

    public void putLong(long index, long value) {
        this.ensureSize(index + 8L);
        this.myStorage.putLong(index, value);
    }

    public byte get(long index) {
        return this.myStorage.get(index);
    }

    public void put(long index, byte value) {
        this.ensureSize(index + 1L);
        this.myStorage.put(index, value);
    }

    public void get(long index, byte[] dst, int offset, int length) {
        this.myStorage.get(index, dst, offset, length);
    }

    public void put(long index, byte[] src, int offset, int length) {
        this.ensureSize(index + (long)length);
        this.myStorage.put(index, src, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.force();
        }
        finally {
            this.myStorage.close();
        }
    }

    public PagedFileStorage getPagedFileStorage() {
        return this.myStorage;
    }
}

