/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StringRef {
    public static final StringRef[] EMPTY_ARRAY = new StringRef[0];
    private int id;
    private String name;
    private final AbstractStringEnumerator store;

    private StringRef(String name) {
        this.name = name;
        this.id = -1;
        this.store = null;
    }

    private StringRef(int id, AbstractStringEnumerator store) {
        this.id = id;
        this.store = store;
        this.name = null;
    }

    public String getString() {
        String name = this.name;
        if (name == null) {
            try {
                this.name = name = (String)this.store.valueOf(this.id);
            }
            catch (IOException e) {
                this.store.markCorrupted();
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    public void writeTo(DataOutput out, AbstractStringEnumerator store) throws IOException {
        int nameId = this.getId(store);
        out.writeByte(nameId & 0xFF);
        DataInputOutputUtil.writeINT(out, nameId >> 8);
    }

    public int getId(AbstractStringEnumerator store) {
        if (this.id == -1) {
            try {
                this.id = store.enumerate(this.name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.id;
    }

    public String toString() {
        return this.getString();
    }

    public int length() {
        return this.getString().length();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        return that == this || that instanceof StringRef && this.toString().equals(that.toString());
    }

    public static String toString(StringRef ref) {
        return ref != null ? ref.getString() : null;
    }

    public static StringRef fromString(String source) {
        return source == null ? null : new StringRef(source);
    }

    public static StringRef fromNullableString(String source) {
        return new StringRef(source == null ? "" : source);
    }

    public static StringRef fromStream(DataInput in, AbstractStringEnumerator store) throws IOException {
        int nameId = DataInputOutputUtil.readINT(in);
        return nameId != 0 ? new StringRef(nameId, store) : null;
    }

    public static StringRef[] createArray(int count) {
        return count == 0 ? EMPTY_ARRAY : new StringRef[count];
    }
}

