/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.ZipUtil");

    private ZipUtil() {
    }

    public static boolean addFileToZip(ZipOutputStream zos, File file, String relativeName, Set<String> writtenItemRelativePaths, FileFilter fileFilter) throws IOException {
        return ZipUtil.addFileToZip(zos, file, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFileToZip(ZipOutputStream zos, File file, String relativeName, Set<String> writtenItemRelativePaths, FileFilter fileFilter, FileContentProcessor contentProcessor) throws IOException {
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        boolean isDir = file.isDirectory();
        if (isDir && !StringUtil.endsWithChar(relativeName, '/')) {
            relativeName = relativeName + "/";
        }
        if (fileFilter != null && !FileUtil.isFilePathAcceptable(file, fileFilter)) {
            return false;
        }
        if (writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file + " as " + relativeName);
        }
        long size = isDir ? 0L : file.length();
        ZipEntry e = new ZipEntry(relativeName);
        e.setTime(file.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            InputStream is = contentProcessor.getContent(file);
            try {
                FileUtil.copy(is, zos);
            }
            finally {
                is.close();
            }
        }
        zos.closeEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(ZipOutputStream jarOutputStream, File jarFile, File file, String relativePath, FileFilter fileFilter, Set<String> writtenItemRelativePaths) throws IOException {
        if (file.isDirectory()) {
            return ZipUtil.addDirToZipRecursively(jarOutputStream, jarFile, file, relativePath, fileFilter, writtenItemRelativePaths);
        }
        ZipUtil.addFileToZip(jarOutputStream, file, relativePath, writtenItemRelativePaths, fileFilter);
        return true;
    }

    public static boolean addDirToZipRecursively(ZipOutputStream outputStream, File jarFile, File dir, String relativePath, FileFilter fileFilter, Set<String> writtenItemRelativePaths) throws IOException {
        File[] children;
        if (jarFile != null && FileUtil.isAncestor(dir, jarFile, false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            ZipUtil.addFileToZip(outputStream, dir, relativePath, writtenItemRelativePaths, fileFilter);
        }
        if ((children = dir.listFiles()) != null) {
            for (File child : children) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                ZipUtil.addFileOrDirRecursively(outputStream, jarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    public static void extract(File file, File outputDir, FilenameFilter filenameFilter) throws IOException {
        ZipUtil.extract(file, outputDir, filenameFilter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File file, File outputDir, FilenameFilter filenameFilter, boolean overwrite) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            ZipUtil.extract(zipFile, outputDir, filenameFilter, overwrite);
        }
        finally {
            zipFile.close();
        }
    }

    public static void extract(ZipFile zipFile, File outputDir, FilenameFilter filenameFilter) throws IOException {
        ZipUtil.extract(zipFile, outputDir, filenameFilter, true);
    }

    public static void extract(ZipFile zipFile, File outputDir, FilenameFilter filenameFilter, boolean overwrite) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(outputDir, entry.getName());
            if (filenameFilter != null && !filenameFilter.accept(file.getParentFile(), file.getName())) continue;
            ZipUtil.extractEntry(entry, zipFile.getInputStream(entry), outputDir, overwrite);
        }
    }

    public static void extractEntry(ZipEntry entry, InputStream inputStream, File outputDir) throws IOException {
        ZipUtil.extractEntry(entry, inputStream, outputDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractEntry(ZipEntry entry, InputStream inputStream, File outputDir, boolean overwrite) throws IOException {
        boolean isDirectory = entry.isDirectory();
        String relativeName = entry.getName();
        File file = new File(outputDir, relativeName);
        if (file.exists() && !overwrite) {
            return;
        }
        FileUtil.createParentDirs(file);
        if (isDirectory) {
            file.mkdir();
        } else {
            BufferedInputStream is = new BufferedInputStream(inputStream);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                FileUtil.copy(is, os);
            }
            finally {
                os.close();
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipContainsFolder(File zip) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        try {
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (zipEntry.getName().indexOf(47) < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipContainsEntry(File zip, String relativePath) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        try {
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (!relativePath.equals(zipEntry.getName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(InputStream in, OutputStream out, Map<String, File> relpathToFile) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipOutputStream zos = new ZipOutputStream(out);
        try {
            ZipEntry e;
            while ((e = zis.getNextEntry()) != null) {
                String name = e.getName();
                if (!relpathToFile.containsKey(name)) {
                    ZipEntry e2 = new ZipEntry(name);
                    e2.setMethod(e.getMethod());
                    e2.setTime(e.getTime());
                    e2.setComment(e.getComment());
                    e2.setExtra(e.getExtra());
                    if (e.getMethod() == 0) {
                        e2.setSize(e.getSize());
                        e2.setCrc(e.getCrc());
                    }
                    zos.putNextEntry(e2);
                    FileUtil.copy(zis, zos);
                    continue;
                }
                File file = relpathToFile.get(name);
                relpathToFile.remove(name);
                ZipUtil.addFileToZip(zos, file, name, null, null);
            }
            for (String path : relpathToFile.keySet()) {
                File file = relpathToFile.get(path);
                ZipUtil.addFileToZip(zos, file, path, null, null);
            }
        }
        finally {
            zis.close();
            zos.close();
        }
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(File file) throws IOException {
                return new FileInputStream(file);
            }
        };

        public InputStream getContent(File var1) throws IOException;
    }
}

