/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.fs;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.fs.IFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class IoFile
implements IFile {
    private final File myFile;
    private static final IFile[] EMPTY_ARRAY = new IFile[0];

    public IoFile(File file) {
        this.myFile = file;
    }

    @Override
    public boolean exists() {
        return this.myFile.exists();
    }

    @Override
    public byte[] loadBytes() throws IOException {
        return FileUtil.loadFileBytes(this.myFile);
    }

    @Override
    public InputStream openInputStream() throws FileNotFoundException {
        return new FileInputStream(this.myFile);
    }

    @Override
    public OutputStream openOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.myFile);
    }

    @Override
    public boolean delete() {
        return this.myFile.delete();
    }

    @Override
    public void renameTo(IFile newFile) throws IOException {
        FileUtil.rename(this.myFile, ((IoFile)newFile).myFile);
    }

    @Override
    public void createParentDirs() {
        FileUtil.createParentDirs(this.myFile);
    }

    @Override
    public IFile getParentFile() {
        return new IoFile(this.myFile.getParentFile());
    }

    @Override
    public String getName() {
        return this.myFile.getName();
    }

    @Override
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    public String getCanonicalPath() {
        if (SystemInfo.isFileSystemCaseSensitive) {
            return this.myFile.getAbsolutePath();
        }
        try {
            return this.myFile.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getAbsolutePath() {
        return this.myFile.getAbsolutePath();
    }

    @Override
    public long length() {
        return this.myFile.length();
    }

    @Override
    public IFile getChild(String childName) {
        return new IoFile(new File(this.myFile, childName));
    }

    @Override
    public boolean isDirectory() {
        return this.myFile.isDirectory();
    }

    @Override
    public IFile[] listFiles() {
        File[] files = this.myFile.listFiles();
        if (files == null) {
            return EMPTY_ARRAY;
        }
        IFile[] result = new IoFile[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new IoFile(files[i]);
        }
        return result;
    }

    @Override
    public void mkDir() {
        this.myFile.mkdir();
    }

    @Override
    public long getTimeStamp() {
        return this.myFile.lastModified();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoFile ioFile = (IoFile)o;
        return this.myFile.equals(ioFile.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    public String toString() {
        return this.myFile.toString();
    }
}

