/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BloomFilterBase;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import com.intellij.util.lang.Loader;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.misc.Resource;

public class ClasspathCache {
    static final Logger LOG = Logger.getInstance(ClasspathCache.class);
    static final boolean doDebug = LOG.isDebugEnabled();
    private final DebugInfo myDebugInfo;
    private final TIntObjectHashMap<Object> myResourcePackagesCache = new TIntObjectHashMap();
    private final TIntObjectHashMap<Object> myClassPackagesCache = new TIntObjectHashMap();
    private THashMap<String, Object> myResources2LoadersTempMap = new THashMap();
    private static final double PROBABILITY = 0.005;
    private Name2LoaderFilter myNameFilter;
    private final ReadWriteLock myLock = new ReentrantReadWriteLock();
    private int registeredBeforeClose;
    private int registeredAfterClose;
    private int hits;
    private int requestsWithoutNameFilter;
    private int falseHits;
    private int requestsWithNameFilter;
    private int avoidedDiskHits2;
    private int falseHits2;
    private int diffs;
    private int diffs2;
    private int diffs3;

    public ClasspathCache() {
        this.myDebugInfo = doDebug ? new DebugInfo() : new NullDebugInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyLoaderData(LoaderData loaderData, Loader loader) {
        this.myLock.writeLock().lock();
        try {
            for (String resourceEntry : loaderData.myResourcePaths) {
                this.addResourceEntry(resourceEntry, loader);
            }
            for (String name : loaderData.myNames) {
                this.addNameEntry(name, loader);
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <ResultType, ParameterType, ParameterType2> ResultType iterateLoaders(String resourcePath, LoaderIterator<ResultType, ParameterType, ParameterType2> iterator, ParameterType parameter, ParameterType2 parameter2) {
        this.myLock.readLock().lock();
        try {
            Loader[] loaders;
            TIntObjectHashMap<Object> map = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
            String packageName = ClasspathCache.getPackageName(resourcePath);
            int hash = packageName.hashCode();
            Object o = map.get(hash);
            this.myDebugInfo.checkLoadersCount(resourcePath, o);
            if (o == null) {
                ResultType ResultType = null;
                return ResultType;
            }
            if (o instanceof Loader) {
                ResultType ResultType = iterator.process((Loader)o, parameter, parameter2);
                return ResultType;
            }
            for (Loader l : loaders = (Loader[])o) {
                ResultType result = iterator.process(l, parameter, parameter2);
                if (result == null) continue;
                ResultType ResultType = result;
                return ResultType;
            }
            ResultType ResultType = null;
            return ResultType;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private static String getPackageName(String resourcePath) {
        int idx = resourcePath.lastIndexOf(47);
        return idx > 0 ? resourcePath.substring(0, idx) : "";
    }

    private void addResourceEntry(String resourcePath, Loader loader) {
        this.myDebugInfo.addResourceEntry(resourcePath, loader);
        String packageName = ClasspathCache.getPackageName(resourcePath);
        TIntObjectHashMap<Object> map = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
        int hash = packageName.hashCode();
        Object o = map.get(hash);
        if (o == null) {
            map.put(hash, (Object)loader);
        } else if (o instanceof Loader) {
            if (o != loader) {
                map.put(hash, (Object)new Loader[]{(Loader)o, loader});
            }
        } else {
            Loader[] loadersArray;
            for (Loader l : loadersArray = (Loader[])o) {
                if (l != loader) continue;
                return;
            }
            map.put(hash, (Object)ArrayUtil.append(loadersArray, loader));
        }
    }

    private void addNameEntry(String name, Loader loader) {
        name = ClasspathCache.transformName(name);
        this.myDebugInfo.addNameEntry(name, loader);
        if (this.myNameFilter == null) {
            Object loaders = this.myResources2LoadersTempMap.get((Object)name);
            boolean added = false;
            if (loaders == null) {
                this.myResources2LoadersTempMap.put((Object)name, (Object)loader);
                added = true;
            } else if (loaders instanceof Loader && loaders != loader) {
                this.myResources2LoadersTempMap.put((Object)name, (Object)new Loader[]{(Loader)loaders, loader});
                added = true;
            } else if (loaders instanceof Loader[]) {
                boolean weHaveThisLoader = false;
                for (Loader existing : (Loader[])loaders) {
                    if (existing != loader) continue;
                    weHaveThisLoader = true;
                    break;
                }
                if (!weHaveThisLoader) {
                    this.myResources2LoadersTempMap.put((Object)name, (Object)ArrayUtil.append((Loader[])loaders, loader));
                    added = true;
                }
            }
            if (doDebug && added) {
                ++this.registeredBeforeClose;
            }
        } else {
            if (doDebug && !this.myNameFilter.maybeContains(name, loader)) {
                ++this.registeredAfterClose;
            }
            this.myNameFilter.add(name, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loaderHasName(String name, String shortName, Loader loader) {
        if (StringUtil.isEmpty(name)) {
            return true;
        }
        this.myLock.readLock().lock();
        try {
            boolean result;
            if (this.myNameFilter == null) {
                Object loaders = this.myResources2LoadersTempMap.get((Object)shortName);
                result = ClasspathCache.contains(loader, loaders);
                if (doDebug) {
                    Resource resource;
                    boolean result2;
                    ++this.requestsWithoutNameFilter;
                    if (!result) {
                        ++this.hits;
                    }
                    if ((result2 = this.myDebugInfo.loaderHasName(shortName, loader)) != result) {
                        ++this.diffs3;
                    }
                    if ((resource = loader.getResource(name, true)) != null && !result || resource == null && result) {
                        ++this.falseHits;
                    }
                    if (this.requestsWithoutNameFilter % 1000 == 0) {
                        LOG.debug("Avoided disk hits: " + this.hits + " from " + this.requestsWithoutNameFilter + ", false hits:" + this.falseHits + ", bitmap diffs:" + this.diffs3);
                    }
                }
            } else {
                result = this.myNameFilter.maybeContains(shortName, loader);
                if (doDebug) {
                    Resource resource;
                    Object loaders;
                    boolean result2;
                    ++this.requestsWithNameFilter;
                    if (!result) {
                        ++this.avoidedDiskHits2;
                    }
                    if ((result2 = this.myDebugInfo.loaderHasName(shortName, loader)) != result) {
                        ++this.diffs2;
                    }
                    if (result != ClasspathCache.contains(loader, loaders = this.myResources2LoadersTempMap.get((Object)shortName))) {
                        ++this.diffs;
                    }
                    if ((resource = loader.getResource(name, true)) == null && result) {
                        ++this.falseHits2;
                    }
                    if (resource != null && !result) {
                        ++this.falseHits2;
                    }
                    if (this.requestsWithNameFilter % 1000 == 0) {
                        LOG.debug("Avoided disk hits2: " + this.avoidedDiskHits2 + " from " + this.requestsWithNameFilter + "," + this.diffs + ", false hits:" + this.falseHits2 + ", bitmap diffs:" + this.diffs2);
                    }
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private static boolean contains(Loader loader, Object loaders) {
        if (loaders == null) {
            return false;
        }
        boolean result = false;
        if (loaders == loader) {
            result = true;
        } else if (loaders instanceof Loader[]) {
            for (Loader existing : (Loader[])loaders) {
                if (existing != loader) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    static String transformName(String name) {
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((name = name.substring(name.lastIndexOf(47) + 1)).endsWith(".class")) {
            String name1 = name;
            int $ = name1.indexOf(36);
            if ($ != -1) {
                name1 = name1.substring(0, $);
            } else {
                int index = name1.lastIndexOf(46);
                if (index >= 0) {
                    name1 = name1.substring(0, index);
                }
            }
            name = name1;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nameSymbolsLoaded() {
        this.myLock.writeLock().lock();
        try {
            if (this.myNameFilter != null) {
                if (doDebug && this.registeredAfterClose > 0) {
                    LOG.debug("Registered number of classes after close " + this.registeredAfterClose + " " + this.toString());
                }
                return;
            }
            if (doDebug) {
                LOG.debug("Registered number of classes before classes " + this.registeredBeforeClose + " " + this.toString());
            }
            int nBits = 0;
            int uniques = 0;
            for (Map.Entry e : this.myResources2LoadersTempMap.entrySet()) {
                int size;
                int n = size = e.getValue() instanceof Loader[] ? ((Loader[])e.getValue()).length : 1;
                if (size == 1) {
                    ++uniques;
                }
                nBits += size;
            }
            if (nBits > 20000) {
                nBits += (int)((double)nBits * 0.03);
            }
            Name2LoaderFilter name2LoaderFilter = new Name2LoaderFilter(nBits, 0.005);
            for (Map.Entry e : this.myResources2LoadersTempMap.entrySet()) {
                String name = (String)e.getKey();
                Object value = e.getValue();
                if (value instanceof Loader) {
                    name2LoaderFilter.add(name, (Loader)value);
                    continue;
                }
                for (Loader loader : (Loader[])value) {
                    name2LoaderFilter.add(name, loader);
                }
            }
            this.myNameFilter = name2LoaderFilter;
            if (!doDebug) {
                this.myResources2LoadersTempMap = null;
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    private static class NullDebugInfo
    extends DebugInfo {
        private NullDebugInfo() {
        }

        @Override
        public void checkLoadersCount(String resourcePath, Object o) {
        }

        @Override
        protected void addResourceEntry(String resourcePath, Loader loader) {
        }

        @Override
        protected void addNameEntry(String name, Loader loader) {
        }

        @Override
        protected boolean loaderHasName(String name, Loader loader) {
            return false;
        }
    }

    private static class DebugInfo {
        private final HashMap<String, List<Loader>> myClassPackagesCache = new HashMap();
        private final HashMap<String, List<Loader>> myResourcePackagesCache = new HashMap();
        private final TIntHashSet myResourceIndex = new TIntHashSet();

        private DebugInfo() {
        }

        private List<Loader> getLoaders(String resourcePath) {
            int idx;
            String packageName;
            boolean isClassFile = resourcePath.endsWith(".class");
            HashMap<String, List<Loader>> map = isClassFile ? this.myClassPackagesCache : this.myResourcePackagesCache;
            SmartList list = (SmartList)map.get(packageName = (idx = resourcePath.lastIndexOf(47)) > 0 ? resourcePath.substring(0, idx) : "");
            if (list == null) {
                list = new SmartList();
                map.put(packageName, list);
            }
            return list;
        }

        protected void addResourceEntry(String resourcePath, Loader loader) {
            List<Loader> loaders = this.getLoaders(resourcePath);
            if (!loaders.contains(loader)) {
                loaders.add(loader);
            }
        }

        protected void addNameEntry(String name, Loader loader) {
            int hash = DebugInfo.hashFromNameAndLoader(name, loader);
            this.myResourceIndex.add(hash);
        }

        protected static int hashFromNameAndLoader(String name, Loader loader) {
            int hash = name.hashCode();
            for (int i = loader.getIndex(); i > 0; i /= 10) {
                hash = hash * 31 + (i % 10 + 48);
            }
            return hash;
        }

        public void checkLoadersCount(String resourcePath, Object o) {
            List<Loader> loaders1 = this.getLoaders(resourcePath);
            if (o == null && !loaders1.isEmpty() || o instanceof Loader && loaders1.size() != 1 || o instanceof Loader[] && loaders1.size() != ((Loader[])o).length) assert (false);
        }

        protected boolean loaderHasName(String name, Loader loader) {
            return this.myResourceIndex.contains(DebugInfo.hashFromNameAndLoader(name, loader));
        }
    }

    private static class Name2LoaderFilter
    extends BloomFilterBase {
        private static final int SEED = 31;

        Name2LoaderFilter(int nBits, double probability) {
            super(nBits, probability);
        }

        private boolean maybeContains(String name, Loader loader) {
            int hash = Name2LoaderFilter.hashFromNameAndLoader(name, loader, StringHash.murmur(name, 31));
            int hash2 = Name2LoaderFilter.hashFromNameAndLoader(name, loader, hash);
            return this.maybeContains(hash, hash2);
        }

        private void add(String name, Loader loader) {
            int hash = Name2LoaderFilter.hashFromNameAndLoader(name, loader, StringHash.murmur(name, 31));
            int hash2 = Name2LoaderFilter.hashFromNameAndLoader(name, loader, hash);
            this.addIt(hash, hash2);
        }

        private static int hashFromNameAndLoader(String name, Loader loader, int n) {
            int hash = StringHash.murmur(name, n);
            for (int i = loader.getIndex(); i > 0; i /= 10) {
                hash = hash * n + (i % 10 + 48);
            }
            return hash;
        }
    }

    static abstract class LoaderIterator<ResultType, ParameterType, ParameterType2> {
        LoaderIterator() {
        }

        abstract ResultType process(Loader var1, ParameterType var2, ParameterType2 var3);
    }

    static class LoaderData {
        private final List<String> myResourcePaths = new ArrayList<String>();
        private final List<String> myNames = new ArrayList<String>();

        LoaderData() {
        }

        public void addResourceEntry(String resourcePath) {
            this.myResourcePaths.add(resourcePath);
        }

        public void addNameEntry(String name) {
            this.myNames.add(ClasspathCache.transformName(name));
        }

        List<String> getResourcePaths() {
            return this.myResourcePaths;
        }

        List<String> getNames() {
            return this.myNames;
        }
    }
}

