/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.Resource;

class MemoryResource
extends Resource {
    private String myName;
    private URL myUrl;
    private final byte[] myContent;

    public MemoryResource(String name, URL url, byte[] content) {
        this.myName = name;
        this.myUrl = url;
        this.myContent = content;
    }

    public String getName() {
        return this.myName;
    }

    public URL getURL() {
        return this.myUrl;
    }

    public URL getCodeSourceURL() {
        return this.myUrl;
    }

    public InputStream getInputStream() throws IOException {
        return new UnsyncByteArrayInputStream(this.myContent);
    }

    public int getContentLength() throws IOException {
        return this.myContent.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryResource load(URL baseUrl, ZipFile zipFile, ZipEntry entry) throws IOException {
        String name = entry.getName();
        URL url = new URL(baseUrl, name);
        byte[] content = ArrayUtil.EMPTY_BYTE_ARRAY;
        InputStream stream = zipFile.getInputStream(entry);
        if (stream != null) {
            try {
                content = FileUtil.loadBytes(stream, (int)entry.getSize());
            }
            finally {
                stream.close();
            }
        }
        return new MemoryResource(name, url, content);
    }
}

