/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.SmartFMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;

public class MessageBusConnectionImpl
implements MessageBusConnection {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusConnectionImpl");
    private final MessageBusImpl myBus;
    private final ThreadLocal<Queue<Message>> myPendingMessages = MessageBusImpl.createThreadLocalQueue();
    private MessageHandler myDefaultHandler;
    private volatile SmartFMap<Topic, Object> mySubscriptions = SmartFMap.emptyMap();

    public MessageBusConnectionImpl(MessageBusImpl bus) {
        this.myBus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> void subscribe(Topic<L> topic, L handler) throws IllegalStateException {
        ThreadLocal<Queue<Message>> threadLocal = this.myPendingMessages;
        synchronized (threadLocal) {
            if (this.mySubscriptions.get(topic) != null) {
                throw new IllegalStateException("Subscription to " + topic + " already exists");
            }
            this.mySubscriptions = this.mySubscriptions.plus(topic, handler);
        }
        this.myBus.notifyOnSubscription(this, topic);
    }

    @Override
    public <L> void subscribe(Topic<L> topic) throws IllegalStateException {
        if (this.myDefaultHandler == null) {
            throw new IllegalStateException("Connection must have default handler installed prior to any anonymous subscriptions. Target topic: " + topic);
        }
        if (topic.getListenerClass().isInstance(this.myDefaultHandler)) {
            throw new IllegalStateException("Can't subscribe to the topic '" + topic + "'. Default handler has incompatible type - expected: '" + topic.getListenerClass() + "', actual: '" + this.myDefaultHandler.getClass() + "'");
        }
        this.subscribe(topic, this.myDefaultHandler);
    }

    @Override
    public void setDefaultHandler(MessageHandler handler) {
        this.myDefaultHandler = handler;
    }

    @Override
    public void disconnect() {
        Queue<Message> jobs = this.myPendingMessages.get();
        this.myPendingMessages.remove();
        this.myBus.notifyConnectionTerminated(this);
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
    }

    @Override
    public void dispose() {
        this.disconnect();
    }

    @Override
    public void deliverImmediately() {
        Queue<Message> messages = this.myPendingMessages.get();
        while (!messages.isEmpty()) {
            this.myBus.deliverSingleMessage();
        }
    }

    void deliverMessage(Message message) {
        Message messageOnLocalQueue = this.myPendingMessages.get().poll();
        assert (messageOnLocalQueue == message);
        Topic topic = message.getTopic();
        Object handler = this.mySubscriptions.get(topic);
        try {
            Method listenerMethod = message.getListenerMethod();
            if (handler == this.myDefaultHandler) {
                this.myDefaultHandler.handle(listenerMethod, message.getArgs());
            } else {
                listenerMethod.invoke(handler, message.getArgs());
            }
        }
        catch (AbstractMethodError e) {
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            LOG.error(e.getCause() == null ? e : e.getCause());
        }
        catch (Throwable e) {
            LOG.error(e.getCause() == null ? e : e.getCause());
        }
    }

    void scheduleMessageDelivery(Message message) {
        this.myPendingMessages.get().offer(message);
    }

    public String toString() {
        return this.mySubscriptions.toString();
    }

    MessageBusImpl getBus() {
        return this.myBus;
    }
}

