/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Map;

public class MessageListenerList<T> {
    private final MessageBus myMessageBus;
    private final Topic<T> myTopic;
    private final Map<T, MessageBusConnection> myListenerToConnectionMap = ContainerUtil.newConcurrentMap();

    public MessageListenerList(MessageBus messageBus, Topic<T> topic) {
        this.myTopic = topic;
        this.myMessageBus = messageBus;
    }

    public void add(T listener) {
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(this.myTopic, listener);
        this.myListenerToConnectionMap.put(listener, connection);
    }

    public void add(final T listener, Disposable parentDisposable) {
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                MessageListenerList.this.myListenerToConnectionMap.remove(listener);
            }
        });
        MessageBusConnection connection = this.myMessageBus.connect(parentDisposable);
        connection.subscribe(this.myTopic, listener);
        this.myListenerToConnectionMap.put(listener, connection);
    }

    public void remove(T listener) {
        MessageBusConnection connection = this.myListenerToConnectionMap.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }
}

