/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharSequenceBackedByArray;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.UnsyncCharArrayReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CharArrayUtil {
    private static final int GET_CHARS_THRESHOLD = 10;

    private CharArrayUtil() {
    }

    public static void getChars(CharSequence src, char[] dst, int dstOffset) {
        CharArrayUtil.getChars(src, dst, dstOffset, src.length());
    }

    public static void getChars(CharSequence src, char[] dst, int dstOffset, int len) {
        CharArrayUtil.getChars(src, dst, 0, dstOffset, len);
    }

    public static void getChars(CharSequence src, char[] dst, int srcOffset, int dstOffset, int len) {
        if (src instanceof CharArrayExternalizable) {
            ((CharArrayExternalizable)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
            return;
        }
        if (len >= 10) {
            if (src instanceof String) {
                ((String)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof CharBuffer) {
                CharBuffer buffer = (CharBuffer)src;
                int i = buffer.position();
                buffer.position(i + srcOffset);
                buffer.get(dst, dstOffset, len);
                buffer.position(i);
                return;
            }
            if (src instanceof CharSequenceBackedByArray) {
                ((CharSequenceBackedByArray)src.subSequence(srcOffset, srcOffset + len)).getChars(dst, dstOffset);
                return;
            }
            if (src instanceof StringBuffer) {
                ((StringBuffer)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof StringBuilder) {
                ((StringBuilder)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
        }
        int i = 0;
        int max = srcOffset + len;
        for (int j = srcOffset; j < max && i < dst.length; ++i, ++j) {
            dst[i + dstOffset] = src.charAt(j);
        }
    }

    public static char[] fromSequenceStrict(CharSequence seq) {
        return CharArrayUtil.fromSequence(seq);
    }

    public static char[] fromSequenceWithoutCopying(CharSequence seq) {
        CharBuffer buffer;
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        if (seq instanceof CharBuffer && (buffer = (CharBuffer)seq).hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0 && buffer.position() == 0) {
            return buffer.array();
        }
        return null;
    }

    public static char[] fromSequence(CharSequence seq) {
        char[] underlying = CharArrayUtil.fromSequenceWithoutCopying(seq);
        return underlying != null ? Arrays.copyOf(underlying, underlying.length) : CharArrayUtil.fromSequence(seq, 0, seq.length());
    }

    public static char[] fromSequence(CharSequence seq, int start, int end) {
        char[] result = new char[end - start];
        CharArrayUtil.getChars(seq, result, start, 0, end - start);
        return result;
    }

    public static int shiftForward(CharSequence buffer, int offset, String chars) {
        return CharArrayUtil.shiftForward(buffer, offset, buffer.length(), chars);
    }

    public static int shiftForward(CharSequence buffer, int startOffset, int endOffset, String chars) {
        int limit = Math.min(endOffset, buffer.length());
        for (int offset = startOffset; offset < limit; ++offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) continue;
            return offset;
        }
        return endOffset;
    }

    public static int shiftForwardCarefully(CharSequence buffer, int offset, String chars) {
        if (offset + 1 >= buffer.length()) {
            return offset;
        }
        if (!CharArrayUtil.isSuitable(chars, buffer.charAt(offset))) {
            return offset;
        }
        ++offset;
        while (offset < buffer.length()) {
            char c = buffer.charAt(offset);
            if (!CharArrayUtil.isSuitable(chars, c)) {
                return offset - 1;
            }
            ++offset;
        }
        return offset - 1;
    }

    private static boolean isSuitable(String chars, char c) {
        for (int i = 0; i < chars.length(); ++i) {
            if (c != chars.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public static int shiftForward(char[] buffer, int offset, String chars) {
        return CharArrayUtil.shiftForward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftBackward(CharSequence buffer, int offset, String chars) {
        return CharArrayUtil.shiftBackward(buffer, 0, offset, chars);
    }

    public static int shiftBackward(CharSequence buffer, int minOffset, int maxOffset, String chars) {
        int offset;
        if (maxOffset >= buffer.length()) {
            return maxOffset;
        }
        for (offset = maxOffset; offset >= minOffset; --offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
        }
        return offset;
    }

    public static int shiftBackward(char[] buffer, int offset, String chars) {
        return CharArrayUtil.shiftBackward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftForwardUntil(CharSequence buffer, int offset, String chars) {
        while (offset < buffer.length()) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            ++offset;
        }
        return offset;
    }

    public static int shiftBackwardUntil(CharSequence buffer, int offset, String chars) {
        if (offset >= buffer.length()) {
            return offset;
        }
        while (offset >= 0) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            --offset;
        }
        return offset;
    }

    public static boolean regionMatches(char[] buffer, int offset, int bufferEnd, CharSequence s) {
        int len = s.length();
        if (offset + len > bufferEnd) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer[offset + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence buffer, int offset, int bufferEnd, CharSequence s) {
        int len = s.length();
        if (offset + len > bufferEnd) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer.charAt(offset + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence buffer, int offset, CharSequence s) {
        if (offset + s.length() > buffer.length()) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (buffer.charAt(offset + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] buffer1, int start1, int end1, char[] buffer2, int start2, int end2) {
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        for (int i = start1; i < end1; ++i) {
            if (buffer1[i] == buffer2[i - start1 + start2]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(char[] buffer, String pattern, int fromIndex) {
        char[] chars = pattern.toCharArray();
        int limit = buffer.length - chars.length + 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence buffer, CharSequence pattern, int fromIndex) {
        return CharArrayUtil.indexOf(buffer, pattern, fromIndex, buffer.length());
    }

    public static int indexOf(CharSequence buffer, CharSequence pattern, int fromIndex, int toIndex) {
        int patternLength = pattern.length();
        int limit = toIndex - patternLength + 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < patternLength; ++j) {
                if (pattern.charAt(j) != buffer.charAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] buffer, char symbol, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (buffer[i] != symbol) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] buffer, char symbol, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (buffer[i] != symbol) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence buffer, String pattern, int maxIndex) {
        char[] chars = pattern.toCharArray();
        int end = buffer.length() - chars.length;
        if (maxIndex > end) {
            maxIndex = end;
        }
        block0: for (int i = maxIndex; i >= 0; --i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer.charAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] buffer, String pattern, int maxIndex) {
        char[] chars = pattern.toCharArray();
        int end = buffer.length - chars.length;
        if (maxIndex > end) {
            maxIndex = end;
        }
        block0: for (int i = maxIndex; i >= 0; --i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static byte[] toByteArray(char[] chars) throws IOException {
        return CharArrayUtil.toByteArray(chars, chars.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(char[] chars, int size) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            writer.write(chars, 0, size);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    public static boolean containsOnlyWhiteSpaces(CharSequence chars) {
        if (chars == null) {
            return true;
        }
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    public static TextRange[] getIndents(CharSequence charsSequence, int shift) {
        List result = new ArrayList<TextRange>();
        int whitespaceEnd = -1;
        int lastTextFound = 0;
        for (int i = charsSequence.length() - 1; i >= 0; --i) {
            char charAt = charsSequence.charAt(i);
            boolean isWhitespace = Character.isWhitespace(charAt);
            if (charAt == '\n') {
                result.add(new TextRange(i, (whitespaceEnd >= 0 ? whitespaceEnd : i) + 1).shiftRight(shift));
                whitespaceEnd = -1;
                continue;
            }
            if (whitespaceEnd >= 0) {
                if (isWhitespace) continue;
                lastTextFound = result.size();
                whitespaceEnd = -1;
                continue;
            }
            if (isWhitespace) {
                whitespaceEnd = i;
                continue;
            }
            lastTextFound = result.size();
        }
        if (whitespaceEnd > 0) {
            result.add(new TextRange(0, whitespaceEnd + 1).shiftRight(shift));
        }
        if (lastTextFound < result.size()) {
            result = result.subList(0, lastTextFound);
        }
        return result.toArray(new TextRange[result.size()]);
    }

    public static boolean containLineBreaks(CharSequence seq) {
        return CharArrayUtil.containLineBreaks(seq, 0, seq.length());
    }

    public static boolean containLineBreaks(CharSequence seq, int fromOffset, int endOffset) {
        if (seq == null) {
            return false;
        }
        for (int i = fromOffset; i < endOffset; ++i) {
            char c = seq.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyOrSpaces(CharSequence text, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n') continue;
            return false;
        }
        return true;
    }

    public static Reader readerFromCharSequence(CharSequence text) {
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(text);
        return chars == null ? new CharSequenceReader(((Object)text).toString()) : new UnsyncCharArrayReader(chars, 0, text.length());
    }
}

