/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class TwoColorsIcon
extends EmptyIcon {
    private final Color myColor1;
    private final Color myColor2;

    public TwoColorsIcon(int size, Color color1, Color color2) {
        super(size, size);
        this.myColor1 = color1;
        this.myColor2 = color2;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        GraphicsUtil.setupAAPainting(g);
        g.setColor(this.myColor1);
        g.fillPolygon(new int[]{x, x + w, x}, new int[]{y, y, y + h}, 3);
        g.setColor(this.myColor2);
        g.fillPolygon(new int[]{x + w, x + w, x}, new int[]{y, y + h, y + h}, 3);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwoColorsIcon icon = (TwoColorsIcon)o;
        if (this.getIconWidth() != icon.getIconWidth()) {
            return false;
        }
        if (this.getIconHeight() != icon.getIconHeight()) {
            return false;
        }
        if (!this.myColor1.equals(icon.myColor1)) {
            return false;
        }
        return this.myColor2.equals(icon.myColor2);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myColor1.hashCode();
        result = 31 * result + this.myColor2.hashCode();
        return result;
    }
}

