/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilterBase;
import gnu.trove.THashMap;
import java.util.Map;
import org.jdom.Element;

public class SkipDefaultValuesSerializationFilters
extends SerializationFilterBase {
    private final Map<Class<?>, Object> myDefaultBeans = new THashMap();

    public SkipDefaultValuesSerializationFilters() {
    }

    public SkipDefaultValuesSerializationFilters(Object ... defaultBeans) {
        for (Object defaultBean : defaultBeans) {
            this.myDefaultBeans.put(defaultBean.getClass(), defaultBean);
        }
    }

    @Override
    protected boolean accepts(Accessor accessor, Object bean, Object beanValue) {
        Object defValue = accessor.read(this.getDefaultBean(bean));
        if (defValue instanceof Element && beanValue instanceof Element) {
            return !JDOMUtil.areElementsEqual((Element)beanValue, (Element)defValue);
        }
        return !Comparing.equal(beanValue, defValue);
    }

    Object getDefaultBean(Object bean) {
        Class<?> c = bean.getClass();
        Object o = this.myDefaultBeans.get(c);
        if (o == null) {
            o = ReflectionUtil.newInstance(c, new Class[0]);
            this.configure(o);
            this.myDefaultBeans.put(c, o);
        }
        return o;
    }

    protected void configure(Object o) {
    }
}

