/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import org.jdom.Element;

public final class SkipDefaultsSerializationFilter
extends SkipDefaultValuesSerializationFilters {
    boolean equal(Binding binding, Object bean) {
        MutableAccessor accessor = binding.getAccessor();
        return this.equal(binding, accessor.read(bean), accessor.read(this.getDefaultBean(bean)));
    }

    boolean equal(Binding binding, Object currentValue, Object defaultValue) {
        Binding referencedBinding;
        if (defaultValue instanceof Element && currentValue instanceof Element) {
            return JDOMUtil.areElementsEqual((Element)currentValue, (Element)defaultValue);
        }
        if (currentValue == defaultValue) {
            return true;
        }
        if (currentValue == null || defaultValue == null) {
            return false;
        }
        if (binding instanceof BasePrimitiveBinding && (referencedBinding = ((BasePrimitiveBinding)binding).myBinding) instanceof BeanBinding) {
            BeanBinding classBinding = (BeanBinding)referencedBinding;
            ThreeState compareByFields = classBinding.hasEqualMethod;
            if (compareByFields == ThreeState.UNSURE) {
                try {
                    classBinding.myBeanClass.getDeclaredMethod("equals", Object.class);
                    compareByFields = ThreeState.NO;
                }
                catch (NoSuchMethodException ignored) {
                    compareByFields = ThreeState.YES;
                }
                catch (Exception e) {
                    Binding.LOG.warn(e);
                }
                classBinding.hasEqualMethod = compareByFields;
            }
            if (compareByFields == ThreeState.YES) {
                return classBinding.equalByFields(currentValue, defaultValue, this);
            }
        }
        return Comparing.equal(currentValue, defaultValue);
    }
}

