/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){

        @Override
        public boolean accepts(Accessor accessor, Object bean) {
            return true;
        }
    };

    private XmlSerializer() {
    }

    public static Element serialize(Object object) throws XmlSerializationException {
        return XmlSerializer.serialize(object, TRUE_FILTER);
    }

    public static Element serialize(Object object, SerializationFilter filter) throws XmlSerializationException {
        return XmlSerializerImpl.serialize(object, filter == null ? TRUE_FILTER : filter);
    }

    public static Element serializeIfNotDefault(Object object, SerializationFilter filter) {
        return XmlSerializerImpl.serializeIfNotDefault(object, filter == null ? TRUE_FILTER : filter);
    }

    public static <T> T deserialize(Document document, Class<T> aClass) throws XmlSerializationException {
        return XmlSerializer.deserialize(document.getRootElement(), aClass);
    }

    public static <T> T deserialize(Element element, Class<T> aClass) throws XmlSerializationException {
        try {
            return (T)XmlSerializerImpl.getBinding(aClass).deserialize(null, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + aClass.getName(), e);
        }
    }

    public static <T> T[] deserialize(Element[] elements, Class<T> aClass) throws XmlSerializationException {
        Object[] result = (Object[])Array.newInstance(aClass, elements.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = XmlSerializer.deserialize(elements[i], aClass);
        }
        return result;
    }

    public static <T> T deserialize(URL url, Class<T> aClass) throws XmlSerializationException {
        try {
            Document document = JDOMUtil.loadDocument(url);
            document = JDOMXIncluder.resolve(document, url.toExternalForm());
            return XmlSerializer.deserialize(document.getRootElement(), aClass);
        }
        catch (IOException e) {
            throw new XmlSerializationException(e);
        }
        catch (JDOMException e) {
            throw new XmlSerializationException(e);
        }
    }

    public static void deserializeInto(Object bean, Element element) {
        XmlSerializer.deserializeInto(bean, element, null);
    }

    public static void deserializeInto(Object bean, Element element, Set<String> accessorNameTracker) {
        try {
            ((BeanBinding)XmlSerializerImpl.getBinding(bean.getClass())).deserializeInto(bean, element, accessorNameTracker);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }

    public static void serializeInto(Object bean, Element element) {
        XmlSerializer.serializeInto(bean, element, null);
    }

    public static void serializeInto(Object bean, Element element, SerializationFilter filter) {
        if (filter == null) {
            filter = TRUE_FILTER;
        }
        try {
            Binding binding = XmlSerializerImpl.getBinding(bean.getClass());
            assert (binding instanceof BeanBinding);
            ((BeanBinding)binding).serializeInto(bean, element, filter);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

