/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.util.xmlb.ArrayBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.CollectionBean;
import java.lang.ref.Reference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

class XmlSerializerImpl {
    private static Reference<Map<Pair<Type, MutableAccessor>, Binding>> ourBindings;

    XmlSerializerImpl() {
    }

    static Element serialize(Object object, SerializationFilter filter) throws XmlSerializationException {
        try {
            Class<?> aClass = object.getClass();
            Binding binding = XmlSerializerImpl.getClassBinding(aClass, aClass, null);
            if (binding instanceof BeanBinding) {
                return ((BeanBinding)binding).serialize(object, true, filter);
            }
            return (Element)binding.serialize(object, null, filter);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Can't serialize instance of " + object.getClass(), e);
        }
    }

    static Element serializeIfNotDefault(Object object, SerializationFilter filter) {
        Class<?> aClass = object.getClass();
        Binding binding = XmlSerializerImpl.getClassBinding(aClass, aClass, null);
        assert (binding != null);
        return (Element)binding.serialize(object, null, filter);
    }

    static Binding getBinding(Type type) {
        return XmlSerializerImpl.getClassBinding(XmlSerializerImpl.typeToClass(type), type, null);
    }

    static Binding getBinding(MutableAccessor accessor) {
        Type type = accessor.getGenericType();
        return XmlSerializerImpl.getClassBinding(XmlSerializerImpl.typeToClass(type), type, accessor);
    }

    static Class<?> typeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            Type bound = ((TypeVariable)type).getBounds()[0];
            return bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
        }
        return (Class)((ParameterizedType)type).getRawType();
    }

    static synchronized Binding getClassBinding(Class<?> aClass, Type originalType, MutableAccessor accessor) {
        if (aClass.isPrimitive() || aClass == String.class || aClass == Integer.class || aClass == Long.class || aClass == Boolean.class || aClass == Double.class || aClass == Float.class || aClass.isEnum() || Date.class.isAssignableFrom(aClass)) {
            return null;
        }
        Pair<Type, MutableAccessor> key = Pair.create(originalType, accessor);
        Map<Pair<Type, MutableAccessor>, Binding> map = XmlSerializerImpl.getBindingCacheMap();
        Binding binding = map.get(key);
        if (binding == null) {
            binding = XmlSerializerImpl.getNonCachedClassBinding(aClass, accessor, originalType);
            map.put(key, binding);
            try {
                binding.init(originalType);
            }
            catch (XmlSerializationException e) {
                map.remove(key);
                throw e;
            }
        }
        return binding;
    }

    private static Map<Pair<Type, MutableAccessor>, Binding> getBindingCacheMap() {
        Map<Pair<Type, MutableAccessor>, Binding> map = SoftReference.dereference(ourBindings);
        if (map == null) {
            map = new ConcurrentHashMap<Pair<Type, MutableAccessor>, Binding>();
            ourBindings = new java.lang.ref.SoftReference<Map<Pair<Type, MutableAccessor>, Binding>>(map);
        }
        return map;
    }

    private static Binding getNonCachedClassBinding(Class<?> aClass, MutableAccessor accessor, Type originalType) {
        if (aClass.isArray()) {
            if (Element.class.isAssignableFrom(aClass.getComponentType())) {
                assert (accessor != null);
                return new JDOMElementBinding(accessor);
            }
            return new ArrayBinding(aClass, accessor);
        }
        if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            CollectionBean listBean;
            if (accessor != null && (listBean = accessor.getAnnotation(CollectionBean.class)) != null) {
                return new CompactCollectionBinding(accessor);
            }
            return new CollectionBinding((ParameterizedType)originalType, accessor);
        }
        if (accessor != null) {
            if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                return new MapBinding(accessor);
            }
            if (Element.class.isAssignableFrom(aClass)) {
                return new JDOMElementBinding(accessor);
            }
            if (JDOMExternalizableStringList.class == aClass) {
                return new CompactCollectionBinding(accessor);
            }
        }
        return new BeanBinding(aClass, accessor);
    }

    static Object convert(String value, Class<?> valueClass) {
        if (value == null) {
            return null;
        }
        if (valueClass == String.class) {
            return value;
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return Integer.parseInt(value);
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return Double.parseDouble(value);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return Long.parseLong(value);
        }
        if (valueClass.isEnum()) {
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                return enumConstant;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            try {
                return new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return new Date(0L);
            }
        }
        return value;
    }

    static void doSet(Object host, String value, MutableAccessor accessor, Class<?> valueClass) {
        if (value == null) {
            accessor.set(host, null);
        } else if (valueClass == String.class) {
            accessor.set(host, value);
        } else if (valueClass == Integer.TYPE) {
            accessor.setInt(host, Integer.parseInt(value));
        } else if (valueClass == Boolean.TYPE) {
            accessor.setBoolean(host, Boolean.parseBoolean(value));
        } else if (valueClass == Double.TYPE) {
            accessor.setDouble(host, Double.parseDouble(value));
        } else if (valueClass == Float.TYPE) {
            accessor.setFloat(host, Float.parseFloat(value));
        } else if (valueClass == Long.TYPE) {
            accessor.setLong(host, Long.parseLong(value));
        } else if (valueClass == Short.TYPE) {
            accessor.setShort(host, Short.parseShort(value));
        } else if (valueClass.isEnum()) {
            Object deserializedValue = null;
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                deserializedValue = enumConstant;
            }
            accessor.set(host, deserializedValue);
        } else if (Date.class.isAssignableFrom(valueClass)) {
            try {
                accessor.set(host, new Date(Long.parseLong(value)));
            }
            catch (NumberFormatException e) {
                accessor.set(host, new Date(0L));
            }
        } else {
            Object deserializedValue = value;
            if (valueClass == Boolean.class) {
                deserializedValue = Boolean.parseBoolean(value);
            } else if (valueClass == Integer.class) {
                deserializedValue = Integer.parseInt(value);
            } else if (valueClass == Short.class) {
                deserializedValue = Short.parseShort(value);
            } else if (valueClass == Long.class) {
                deserializedValue = Long.parseLong(value);
            } else if (valueClass == Double.class) {
                deserializedValue = Double.parseDouble(value);
            } else if (valueClass == Float.class) {
                deserializedValue = Float.valueOf(Float.parseFloat(value));
            }
            accessor.set(host, deserializedValue);
        }
    }

    static String convertToString(Object value) {
        if (value instanceof Date) {
            return Long.toString(((Date)value).getTime());
        }
        return value.toString();
    }

    static String getTextValue(Element element, String defaultText) {
        Content child;
        List content = element.getContent();
        String value = defaultText;
        if (!content.isEmpty() && (child = (Content)content.get(0)) instanceof Text) {
            value = child.getValue();
        }
        return value;
    }
}

