/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.groovy.GroovyBuilderExtension;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class GriffonBuilderExtension
implements GroovyBuilderExtension {
    @Override
    public Collection<String> getCompilationClassPath(CompileContext context, ModuleChunk chunk) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getCompilationUnitPatchers(CompileContext context, ModuleChunk chunk) {
        for (JpsModule module : chunk.getModules()) {
            if (!GriffonBuilderExtension.shouldInjectGriffon(module)) continue;
            return Collections.singleton("org.jetbrains.groovy.compiler.rt.GriffonInjector");
        }
        return Collections.emptyList();
    }

    private static boolean shouldInjectGriffon(JpsModule module) {
        for (String rootUrl : module.getContentRootsList().getUrls()) {
            File root = JpsPathUtil.urlToFile((String)rootUrl);
            if (!new File(root, "griffon-app").isDirectory() || !new File(root, "application.properties").isFile()) continue;
            return true;
        }
        return false;
    }
}

