/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.impl.compiler.JpsCompilerExcludesImpl;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerConfigurationSerializer;

public class JpsGroovySettings
extends JpsElementBase<JpsGroovySettings> {
    static final JpsElementChildRole<JpsGroovySettings> ROLE = JpsElementChildRoleBase.create((String)"Groovy Compiler Configuration");
    public static final String DEFAULT_HEAP_SIZE = "400";
    public static final boolean DEFAULT_INVOKE_DYNAMIC = false;
    public static final boolean DEFAULT_TRANSFORMS_OK = false;
    public String heapSize = "400";
    public boolean invokeDynamic = false;
    @Tag(value="excludes")
    public Element excludes = new Element("aaa");
    public boolean transformsOk = false;
    private JpsCompilerExcludes myExcludeFromStubGeneration;

    public JpsGroovySettings() {
    }

    public JpsGroovySettings(JpsGroovySettings original) {
        this.heapSize = original.heapSize;
        this.invokeDynamic = original.invokeDynamic;
    }

    void initExcludes() {
        this.myExcludeFromStubGeneration = new JpsCompilerExcludesImpl();
        JpsJavaCompilerConfigurationSerializer.readExcludes((Element)this.excludes, (JpsCompilerExcludes)this.myExcludeFromStubGeneration);
    }

    public JpsGroovySettings createCopy() {
        return new JpsGroovySettings(this);
    }

    public void applyChanges(JpsGroovySettings modified) {
    }

    public static JpsGroovySettings getSettings(JpsProject project) {
        JpsGroovySettings settings = (JpsGroovySettings)project.getContainer().getChild(ROLE);
        return settings == null ? new JpsGroovySettings() : settings;
    }

    public boolean isExcludedFromStubGeneration(File file) {
        return this.myExcludeFromStubGeneration != null && this.myExcludeFromStubGeneration.isExcluded(file);
    }
}

