/*
 * Decompiled with CFR 0.152.
 */
package org.java.ayatana;

import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public final class DesktopFile {
    public static final String BOOLEAN_TRUE = "true";
    public static final String BOOLEAN_FALSE = "false";
    public static final String TYPE_APPLICATION = "Application";
    public static final String TYPE_TERMINAL = "Terminal";
    private static DesktopFile desktopFile = null;
    private static File localFileDesktop = null;
    private String desktopFileName;
    private String defaultName;
    private Map<Locale, String> names;
    private String defaultComment;
    private Map<Locale, String> comments;
    private String command;
    private String icon;
    private String categories;
    private String startupWMClass;
    private String startupNotify = "true";
    private String terminal = "false";
    private String type = "Application";
    private boolean changed = false;

    public static DesktopFile initialize(String desktopFileName, String startupWMClass) throws IOException {
        if (desktopFileName == null) {
            throw new NullPointerException("desktopFileName can't be null");
        }
        desktopFile = new DesktopFile(desktopFileName, startupWMClass);
        return desktopFile;
    }

    public static DesktopFile getInstance() {
        if (desktopFile == null) {
            throw new IllegalAccessError("DesktopFile is not initialized");
        }
        return desktopFile;
    }

    private DesktopFile(String desktopFileName, String startupWMClass) throws IOException {
        this.desktopFileName = desktopFileName;
        if (!this.desktopFileName.endsWith(".desktop")) {
            this.desktopFileName = this.desktopFileName + ".desktop";
        }
        this.names = new TreeMap<Locale, String>();
        this.comments = new TreeMap<Locale, String>();
        this.load();
        this.setStartupWMClass(startupWMClass);
    }

    public void setName(String name) {
        this.defaultName = name;
    }

    public void setName(String name, Locale locale) {
        String old = this.names.put(locale, name);
        if (old == null ? old != null : !old.equals(name)) {
            this.changed = true;
        }
    }

    public String getName() {
        return this.defaultName;
    }

    public String getName(Locale locale) {
        return this.names.get(locale);
    }

    public void setComment(String comment) {
        this.defaultComment = comment;
    }

    public void setComment(String comment, Locale locale) {
        String old = this.comments.put(locale, comment);
        if (old == null ? old != null : !old.equals(old)) {
            this.changed = true;
        }
    }

    public String getComment() {
        return this.defaultComment;
    }

    public String getComment(Locale locale) {
        return this.comments.get(locale);
    }

    public void setCommand(String command) {
        if (this.command == null ? command != null : !this.command.equals(command)) {
            this.changed = true;
        }
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setIcon(String icon) {
        if (this.icon == null ? icon != null : !this.icon.equals(icon)) {
            this.changed = true;
        }
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    private String toStringCategories(String ... categories) {
        if (categories == null) {
            return null;
        }
        if (categories.length == 0) {
            return null;
        }
        String out = "";
        for (String c : categories) {
            out = out + c + ";";
        }
        out = out.substring(0, out.length() - 1);
        return out;
    }

    public void setCategories(String ... categories) {
        if (categories == null) {
            throw new NullPointerException();
        }
        if (this.categories == null ? categories.length > 0 : !this.categories.equals(this.toStringCategories(categories))) {
            this.changed = true;
        }
        this.categories = this.toStringCategories(categories);
    }

    public String getCategories() {
        return this.categories;
    }

    public void setStartupWMClass(String startupWMClass) {
        if (startupWMClass == null) {
            throw new NullPointerException("startupWMClass can't be null");
        }
        if (this.startupWMClass == null ? startupWMClass != null : !this.startupWMClass.equals(startupWMClass)) {
            this.changed = true;
        }
        this.startupWMClass = startupWMClass;
        if (this.changed) {
            DesktopFile.setStartupWMClassToToolKit(startupWMClass);
        }
    }

    public static String getStartupWMClassFromToolKit() {
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            String out = (String)awtAppClassNameField.get(xToolkit);
            awtAppClassNameField.setAccessible(false);
            return out;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStartupWMClassToToolKit() {
        DesktopFile.setStartupWMClassToToolKit(DesktopFile.getInstance().getStartupWMClass());
    }

    public static void setStartupWMClassToToolKit(String startupWMClass) {
        try {
            System.setProperty("java.awt.WM_CLASS", startupWMClass);
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, startupWMClass);
            awtAppClassNameField.setAccessible(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getStartupWMClass() {
        return this.startupWMClass;
    }

    private String getStartupNotify() {
        return this.startupNotify;
    }

    private void setStartupNotify(String startupNotify) {
        if (this.startupNotify == null ? startupNotify != null : !this.startupNotify.equals(startupNotify)) {
            this.changed = true;
        }
        this.startupNotify = startupNotify;
    }

    private String getTerminal() {
        return this.terminal;
    }

    private void setTerminal(String terminal) {
        if (this.terminal == null ? terminal != null : !this.terminal.equals(terminal)) {
            this.changed = true;
        }
        this.terminal = terminal;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (this.type == null ? type != null : !this.type.equals(type)) {
            this.changed = true;
        }
        this.type = type;
    }

    private Locale resolveLocale(String lang) {
        Locale locale;
        if (lang.contains("_")) {
            String[] param = lang.split("_");
            locale = new Locale(param[0], param[1]);
        } else {
            locale = new Locale(lang);
        }
        return locale;
    }

    public boolean load() throws IOException {
        File deskFile = this.getLocalFile();
        if (!deskFile.exists()) {
            deskFile = new File("/usr/share/applications/" + this.getDesktopFileName());
        }
        if (deskFile.exists()) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(deskFile));
            while ((line = reader.readLine()) != null) {
                String lang;
                if (!line.contains("=") || line.startsWith("#")) continue;
                String[] param = line.split("=");
                String key = param[0].trim().toLowerCase();
                String value = param[1].trim();
                if (key.startsWith("name")) {
                    if (key.endsWith("]")) {
                        lang = key.substring(key.indexOf("[") + 1, key.length() - 1);
                        this.setName(value, this.resolveLocale(lang));
                        continue;
                    }
                    this.setName(value);
                    continue;
                }
                if (key.startsWith("comment")) {
                    if (key.endsWith("]")) {
                        lang = key.substring(key.indexOf("[") + 1, key.length() - 1);
                        this.setComment(value, this.resolveLocale(lang));
                        continue;
                    }
                    this.setComment(value);
                    continue;
                }
                if (key.equals("encoding")) continue;
                if (key.equals("exec")) {
                    this.setCommand(value);
                    continue;
                }
                if (key.equals("icon")) {
                    this.setIcon(value);
                    continue;
                }
                if (key.equals("categories")) {
                    this.setCategories(value.split(","));
                    continue;
                }
                if (key.equals("startupwmclass")) {
                    this.setStartupWMClass(value);
                    continue;
                }
                if (key.equals("startupnotify")) {
                    this.setStartupNotify(value);
                    continue;
                }
                if (key.equals("type")) {
                    this.setType(value);
                    continue;
                }
                if (!key.equals("terminal")) continue;
                this.setTerminal(value);
            }
            reader.close();
            this.changed = false;
            return true;
        }
        return false;
    }

    public boolean update() throws IOException {
        if (this.changed) {
            File df = this.getLocalFile();
            df.getParentFile().mkdirs();
            BufferedWriter writer = new BufferedWriter(new FileWriter(df));
            writer.write("[Desktop Entry]");
            writer.newLine();
            if (this.getName() != null) {
                writer.write("Name=" + this.getName());
                writer.newLine();
            }
            for (Map.Entry<Locale, String> entry : this.names.entrySet()) {
                if (entry.getValue() == null) continue;
                writer.write("Name[" + entry.getKey().toString() + "]=" + entry.getValue());
                writer.newLine();
            }
            if (this.getComment() != null) {
                writer.write("Comment=" + this.getComment());
                writer.newLine();
            }
            for (Map.Entry<Locale, String> entry : this.comments.entrySet()) {
                if (entry.getValue() == null) continue;
                writer.write("Comment[" + entry.getKey().toString() + "]=" + entry.getValue());
                writer.newLine();
            }
            if (this.getCommand() != null) {
                writer.write("Exec=" + this.getCommand());
                writer.newLine();
            }
            if (this.getIcon() != null) {
                writer.write("Icon=" + this.getIcon());
                writer.newLine();
            }
            if (this.getCategories() != null) {
                writer.write("Categories=" + this.getCategories());
                writer.newLine();
            }
            if (this.getStartupWMClass() != null) {
                writer.write("StartupWMClass=" + this.getStartupWMClass());
                writer.newLine();
            }
            if (this.getStartupNotify() != null) {
                writer.write("StartupNotify=" + this.getStartupNotify());
                writer.newLine();
            }
            if (this.getTerminal() != null) {
                writer.write("Terminal=" + this.getTerminal());
                writer.newLine();
            }
            if (this.getType() != null) {
                writer.write("Type=" + this.getType());
                writer.newLine();
            }
            writer.close();
            try {
                Runtime.getRuntime().exec("xdg-desktop-menu forceupdate");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.changed = false;
            return true;
        }
        return false;
    }

    public boolean delete() {
        return this.getLocalFile().delete();
    }

    public String getDesktopFileName() {
        return this.desktopFileName;
    }

    File getLocalFile() {
        if (localFileDesktop == null) {
            localFileDesktop = new File(System.getProperty("user.home"), "/.local/share/applications/" + this.getDesktopFileName());
        }
        return localFileDesktop;
    }
}

