/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import java.io.IOException;
import java.io.InputStream;

public class Input
extends InputStream {
    protected byte[] buffer;
    protected int position;
    protected int capacity;
    protected int limit;
    protected int total;
    protected char[] chars = new char[32];
    protected InputStream inputStream;

    public Input() {
    }

    public Input(int n) {
        this.capacity = n;
        this.buffer = new byte[n];
    }

    public Input(byte[] byArray) {
        this.setBuffer(byArray, 0, byArray.length);
    }

    public Input(byte[] byArray, int n, int n2) {
        this.setBuffer(byArray, n, n2);
    }

    public Input(InputStream inputStream) {
        this(4096);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public Input(InputStream inputStream, int n) {
        this(n);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public void setBuffer(byte[] byArray) {
        this.setBuffer(byArray, 0, byArray.length);
    }

    public void setBuffer(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.buffer = byArray;
        this.position = n;
        this.limit = n + n2;
        this.capacity = byArray.length;
        this.total = 0;
        this.inputStream = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.limit = 0;
        this.rewind();
    }

    public int total() {
        return this.total + this.position;
    }

    public void setTotal(int n) {
        this.total = n;
    }

    public final int position() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public final int limit() {
        return this.limit;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void rewind() {
        this.position = 0;
        this.total = 0;
    }

    public void skip(int n) throws KryoException {
        int n2 = Math.min(this.limit - this.position, n);
        while (true) {
            this.position += n2;
            if ((n -= n2) == 0) break;
            n2 = Math.min(n, this.capacity);
            this.require(n2);
        }
    }

    protected int fill(byte[] byArray, int n, int n2) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            return this.inputStream.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
    }

    protected int require(int n) throws KryoException {
        int n2;
        int n3 = this.limit - this.position;
        if (n3 >= n) {
            return n3;
        }
        if (n > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + n);
        }
        if (n3 > 0) {
            n2 = this.fill(this.buffer, this.limit, this.capacity - this.limit);
            if (n2 == -1) {
                throw new KryoException("Buffer underflow.");
            }
            if ((n3 += n2) >= n) {
                this.limit += n2;
                return n3;
            }
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, n3);
        this.total += this.position;
        this.position = 0;
        do {
            if ((n2 = this.fill(this.buffer, n3, this.capacity - n3)) != -1) continue;
            if (n3 >= n) break;
            throw new KryoException("Buffer underflow.");
        } while ((n3 += n2) < n);
        this.limit = n3;
        return n3;
    }

    private int optional(int n) throws KryoException {
        int n2 = this.limit - this.position;
        if (n2 >= n) {
            return n;
        }
        n = Math.min(n, this.capacity);
        int n3 = this.fill(this.buffer, this.limit, this.capacity - this.limit);
        if (n3 == -1) {
            return n2 == 0 ? -1 : Math.min(n2, n);
        }
        if ((n2 += n3) >= n) {
            this.limit += n3;
            return n;
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, n2);
        this.total += this.position;
        this.position = 0;
        while ((n3 = this.fill(this.buffer, n2, this.capacity - n2)) != -1 && (n2 += n3) < n) {
        }
        this.limit = n2;
        return n2 == 0 ? -1 : Math.min(n2, n);
    }

    public boolean eof() {
        return this.optional(1) <= 0;
    }

    @Override
    public int available() throws IOException {
        return this.limit - this.position + (null != this.inputStream ? this.inputStream.available() : 0);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws KryoException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n3 = n2;
        int n4 = Math.min(this.limit - this.position, n2);
        do {
            System.arraycopy(this.buffer, this.position, byArray, n, n4);
            this.position += n4;
            if ((n2 -= n4) == 0) break;
            n += n4;
            n4 = this.optional(n2);
            if (n4 != -1) continue;
            if (n3 == n2) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return n3 - n2;
    }

    @Override
    public long skip(long l) throws KryoException {
        int n;
        for (long i = l; i > 0L; i -= (long)n) {
            n = Math.min(Integer.MAX_VALUE, (int)i);
            this.skip(n);
        }
        return l;
    }

    @Override
    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte readByte() throws KryoException {
        this.require(1);
        return this.buffer[this.position++];
    }

    public int readByteUnsigned() throws KryoException {
        this.require(1);
        return this.buffer[this.position++] & 0xFF;
    }

    public byte[] readBytes(int n) throws KryoException {
        byte[] byArray = new byte[n];
        this.readBytes(byArray, 0, n);
        return byArray;
    }

    public void readBytes(byte[] byArray) throws KryoException {
        this.readBytes(byArray, 0, byArray.length);
    }

    public void readBytes(byte[] byArray, int n, int n2) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n3 = Math.min(this.limit - this.position, n2);
        while (true) {
            System.arraycopy(this.buffer, this.position, byArray, n, n3);
            this.position += n3;
            if ((n2 -= n3) == 0) break;
            n += n3;
            n3 = Math.min(n2, this.capacity);
            this.require(n3);
        }
    }

    public int readInt() throws KryoException {
        this.require(4);
        byte[] byArray = this.buffer;
        int n = this.position;
        this.position = n + 4;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public int readInt(boolean bl) throws KryoException {
        return this.readVarInt(bl);
    }

    public int readVarInt(boolean bl) throws KryoException {
        if (this.require(1) < 5) {
            return this.readInt_slow(bl);
        }
        byte by = this.buffer[this.position++];
        int n = by & 0x7F;
        if ((by & 0x80) != 0) {
            byte[] byArray = this.buffer;
            by = byArray[this.position++];
            n |= (by & 0x7F) << 7;
            if ((by & 0x80) != 0) {
                by = byArray[this.position++];
                n |= (by & 0x7F) << 14;
                if ((by & 0x80) != 0) {
                    by = byArray[this.position++];
                    n |= (by & 0x7F) << 21;
                    if ((by & 0x80) != 0) {
                        by = byArray[this.position++];
                        n |= (by & 0x7F) << 28;
                    }
                }
            }
        }
        return bl ? n : n >>> 1 ^ -(n & 1);
    }

    private int readInt_slow(boolean bl) {
        byte by = this.buffer[this.position++];
        int n = by & 0x7F;
        if ((by & 0x80) != 0) {
            this.require(1);
            byte[] byArray = this.buffer;
            by = byArray[this.position++];
            n |= (by & 0x7F) << 7;
            if ((by & 0x80) != 0) {
                this.require(1);
                by = byArray[this.position++];
                n |= (by & 0x7F) << 14;
                if ((by & 0x80) != 0) {
                    this.require(1);
                    by = byArray[this.position++];
                    n |= (by & 0x7F) << 21;
                    if ((by & 0x80) != 0) {
                        this.require(1);
                        by = byArray[this.position++];
                        n |= (by & 0x7F) << 28;
                    }
                }
            }
        }
        return bl ? n : n >>> 1 ^ -(n & 1);
    }

    public boolean canReadInt() throws KryoException {
        if (this.limit - this.position >= 5) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int n = this.position;
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        return n != this.limit;
    }

    public boolean canReadLong() throws KryoException {
        if (this.limit - this.position >= 9) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int n = this.position;
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.buffer[n++] & 0x80) == 0) {
            return true;
        }
        return n != this.limit;
    }

    public String readString() {
        byte by;
        int n = this.require(1);
        if (((by = this.buffer[this.position++]) & 0x80) == 0) {
            return this.readAscii();
        }
        int n2 = n >= 5 ? this.readUtf8Length(by) : this.readUtf8Length_slow(by);
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --n2) {
            this.chars = new char[n2];
        }
        this.readUtf8(n2);
        return new String(this.chars, 0, n2);
    }

    private int readUtf8Length(int n) {
        int n2 = n & 0x3F;
        if ((n & 0x40) != 0) {
            byte[] byArray = this.buffer;
            n = byArray[this.position++];
            n2 |= (n & 0x7F) << 6;
            if ((n & 0x80) != 0) {
                n = byArray[this.position++];
                n2 |= (n & 0x7F) << 13;
                if ((n & 0x80) != 0) {
                    n = byArray[this.position++];
                    n2 |= (n & 0x7F) << 20;
                    if ((n & 0x80) != 0) {
                        n = byArray[this.position++];
                        n2 |= (n & 0x7F) << 27;
                    }
                }
            }
        }
        return n2;
    }

    private int readUtf8Length_slow(int n) {
        int n2 = n & 0x3F;
        if ((n & 0x40) != 0) {
            this.require(1);
            byte[] byArray = this.buffer;
            n = byArray[this.position++];
            n2 |= (n & 0x7F) << 6;
            if ((n & 0x80) != 0) {
                this.require(1);
                n = byArray[this.position++];
                n2 |= (n & 0x7F) << 13;
                if ((n & 0x80) != 0) {
                    this.require(1);
                    n = byArray[this.position++];
                    n2 |= (n & 0x7F) << 20;
                    if ((n & 0x80) != 0) {
                        this.require(1);
                        n = byArray[this.position++];
                        n2 |= (n & 0x7F) << 27;
                    }
                }
            }
        }
        return n2;
    }

    private void readUtf8(int n) {
        byte[] byArray = this.buffer;
        char[] cArray = this.chars;
        int n2 = 0;
        int n3 = Math.min(this.require(1), n);
        int n4 = this.position;
        while (n2 < n3) {
            byte by;
            if ((by = byArray[n4++]) < 0) {
                --n4;
                break;
            }
            cArray[n2++] = (char)by;
        }
        this.position = n4;
        if (n2 < n) {
            this.readUtf8_slow(n, n2);
        }
    }

    private void readUtf8_slow(int n, int n2) {
        char[] cArray = this.chars;
        byte[] byArray = this.buffer;
        while (n2 < n) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int n3 = byArray[this.position++] & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n2] = (char)n3;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    cArray[n2] = (char)((n3 & 0x1F) << 6 | byArray[this.position++] & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    cArray[n2] = (char)((n3 & 0xF) << 12 | (byArray[this.position++] & 0x3F) << 6 | byArray[this.position++] & 0x3F);
                }
            }
            ++n2;
        }
    }

    private String readAscii() {
        byte by;
        byte[] byArray = this.buffer;
        int n = this.position;
        int n2 = n - 1;
        int n3 = this.limit;
        do {
            if (n != n3) continue;
            return this.readAscii_slow();
        } while (((by = byArray[n++]) & 0x80) == 0);
        int n4 = n - 1;
        byArray[n4] = (byte)(byArray[n4] & 0x7F);
        String string = new String(byArray, 0, n2, n - n2);
        int n5 = n - 1;
        byArray[n5] = (byte)(byArray[n5] | 0x80);
        this.position = n;
        return string;
    }

    private String readAscii_slow() {
        --this.position;
        int n = this.limit - this.position;
        if (n > this.chars.length) {
            this.chars = new char[n * 2];
        }
        char[] cArray = this.chars;
        byte[] byArray = this.buffer;
        int n2 = this.position;
        int n3 = 0;
        int n4 = this.limit;
        while (n2 < n4) {
            cArray[n3] = (char)byArray[n2];
            ++n2;
            ++n3;
        }
        this.position = this.limit;
        while (true) {
            this.require(1);
            n2 = byArray[this.position++];
            if (n == cArray.length) {
                char[] cArray2 = new char[n * 2];
                System.arraycopy(cArray, 0, cArray2, 0, n);
                cArray = cArray2;
                this.chars = cArray2;
            }
            if ((n2 & 0x80) == 128) break;
            cArray[n++] = (char)n2;
        }
        cArray[n++] = (char)(n2 & 0x7F);
        return new String(cArray, 0, n);
    }

    public StringBuilder readStringBuilder() {
        byte by;
        int n = this.require(1);
        if (((by = this.buffer[this.position++]) & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int n2 = n >= 5 ? this.readUtf8Length(by) : this.readUtf8Length_slow(by);
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        if (this.chars.length < --n2) {
            this.chars = new char[n2];
        }
        this.readUtf8(n2);
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(this.chars, 0, n2);
        return stringBuilder;
    }

    public float readFloat() throws KryoException {
        return Float.intBitsToFloat(this.readInt());
    }

    public float readFloat(float f, boolean bl) throws KryoException {
        return (float)this.readInt(bl) / f;
    }

    public short readShort() throws KryoException {
        this.require(2);
        return (short)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
    }

    public int readShortUnsigned() throws KryoException {
        this.require(2);
        return (this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF;
    }

    public long readLong() throws KryoException {
        this.require(8);
        byte[] byArray = this.buffer;
        return (long)byArray[this.position++] << 56 | (long)(byArray[this.position++] & 0xFF) << 48 | (long)(byArray[this.position++] & 0xFF) << 40 | (long)(byArray[this.position++] & 0xFF) << 32 | (long)(byArray[this.position++] & 0xFF) << 24 | (long)((byArray[this.position++] & 0xFF) << 16) | (long)((byArray[this.position++] & 0xFF) << 8) | (long)(byArray[this.position++] & 0xFF);
    }

    public long readLong(boolean bl) throws KryoException {
        return this.readVarLong(bl);
    }

    public long readVarLong(boolean bl) throws KryoException {
        if (this.require(1) < 9) {
            return this.readLong_slow(bl);
        }
        byte by = this.buffer[this.position++];
        long l = by & 0x7F;
        if ((by & 0x80) != 0) {
            byte[] byArray = this.buffer;
            by = byArray[this.position++];
            l |= (long)((by & 0x7F) << 7);
            if ((by & 0x80) != 0) {
                by = byArray[this.position++];
                l |= (long)((by & 0x7F) << 14);
                if ((by & 0x80) != 0) {
                    by = byArray[this.position++];
                    l |= (long)((by & 0x7F) << 21);
                    if ((by & 0x80) != 0) {
                        by = byArray[this.position++];
                        l |= (long)(by & 0x7F) << 28;
                        if ((by & 0x80) != 0) {
                            by = byArray[this.position++];
                            l |= (long)(by & 0x7F) << 35;
                            if ((by & 0x80) != 0) {
                                by = byArray[this.position++];
                                l |= (long)(by & 0x7F) << 42;
                                if ((by & 0x80) != 0) {
                                    by = byArray[this.position++];
                                    l |= (long)(by & 0x7F) << 49;
                                    if ((by & 0x80) != 0) {
                                        by = byArray[this.position++];
                                        l |= (long)by << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl) {
            l = l >>> 1 ^ -(l & 1L);
        }
        return l;
    }

    private long readLong_slow(boolean bl) {
        byte by = this.buffer[this.position++];
        long l = by & 0x7F;
        if ((by & 0x80) != 0) {
            this.require(1);
            byte[] byArray = this.buffer;
            by = byArray[this.position++];
            l |= (long)((by & 0x7F) << 7);
            if ((by & 0x80) != 0) {
                this.require(1);
                by = byArray[this.position++];
                l |= (long)((by & 0x7F) << 14);
                if ((by & 0x80) != 0) {
                    this.require(1);
                    by = byArray[this.position++];
                    l |= (long)((by & 0x7F) << 21);
                    if ((by & 0x80) != 0) {
                        this.require(1);
                        by = byArray[this.position++];
                        l |= (long)(by & 0x7F) << 28;
                        if ((by & 0x80) != 0) {
                            this.require(1);
                            by = byArray[this.position++];
                            l |= (long)(by & 0x7F) << 35;
                            if ((by & 0x80) != 0) {
                                this.require(1);
                                by = byArray[this.position++];
                                l |= (long)(by & 0x7F) << 42;
                                if ((by & 0x80) != 0) {
                                    this.require(1);
                                    by = byArray[this.position++];
                                    l |= (long)(by & 0x7F) << 49;
                                    if ((by & 0x80) != 0) {
                                        this.require(1);
                                        by = byArray[this.position++];
                                        l |= (long)by << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl) {
            l = l >>> 1 ^ -(l & 1L);
        }
        return l;
    }

    public boolean readBoolean() throws KryoException {
        this.require(1);
        return this.buffer[this.position++] == 1;
    }

    public char readChar() throws KryoException {
        this.require(2);
        return (char)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
    }

    public double readDouble() throws KryoException {
        return Double.longBitsToDouble(this.readLong());
    }

    public double readDouble(double d, boolean bl) throws KryoException {
        return (double)this.readLong(bl) / d;
    }

    public int[] readInts(int n, boolean bl) throws KryoException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readInt(bl);
        }
        return nArray;
    }

    public long[] readLongs(int n, boolean bl) throws KryoException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.readLong(bl);
        }
        return lArray;
    }

    public int[] readInts(int n) throws KryoException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readInt();
        }
        return nArray;
    }

    public long[] readLongs(int n) throws KryoException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.readLong();
        }
        return lArray;
    }

    public float[] readFloats(int n) throws KryoException {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.readFloat();
        }
        return fArray;
    }

    public short[] readShorts(int n) throws KryoException {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = this.readShort();
        }
        return sArray;
    }

    public char[] readChars(int n) throws KryoException {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.readChar();
        }
        return cArray;
    }

    public double[] readDoubles(int n) throws KryoException {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.readDouble();
        }
        return dArray;
    }
}

