/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.build.OutputFile;
import com.android.build.gradle.internal.dsl.SplitOptions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class AbiSplitOptions
extends SplitOptions {
    private boolean universalApk = false;

    public boolean isUniversalApk() {
        return this.universalApk;
    }

    public void setUniversalApk(boolean universalApk) {
        this.universalApk = universalApk;
    }

    @Override
    @NonNull
    public Set<String> getApplicableFilters(@NonNull Set<String> allFilters) {
        Set<String> list = super.getApplicableFilters(allFilters);
        if (this.isEnable() && this.universalApk) {
            list.add(OutputFile.NO_FILTER);
        }
        return list;
    }

    @NonNull
    public static ImmutableSet<String> getAbiFilters(@NonNull Set<String> allFilters) {
        ImmutableSet.Builder filters = ImmutableSet.builder();
        for (String abi : allFilters) {
            if (abi == OutputFile.NO_FILTER) continue;
            filters.add((Object)abi);
        }
        return filters.build();
    }
}

