/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.LibraryDependencyImpl;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.model.AndroidLibraryImpl;
import com.android.build.gradle.internal.model.JavaLibraryImpl;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DependenciesImpl
implements Dependencies,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final List<AndroidLibrary> libraries;
    @NonNull
    private final List<JavaLibrary> javaLibraries;
    @NonNull
    private final List<String> projects;

    @NonNull
    static DependenciesImpl cloneDependenciesForJavaArtifacts(@NonNull Dependencies dependencies) {
        List<AndroidLibrary> libraries = Collections.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies.getJavaLibraries());
        List<String> projects = Collections.emptyList();
        return new DependenciesImpl(libraries, javaLibraries, projects);
    }

    @NonNull
    static DependenciesImpl cloneDependencies(@NonNull BaseVariantData variantData, @NonNull AndroidBuilder androidBuilder) {
        File supportJar;
        VariantDependencies variantDependencies = variantData.getVariantDependency();
        List<LibraryDependencyImpl> libs = variantDependencies.getLibraries();
        ArrayList libraries = Lists.newArrayListWithCapacity((int)libs.size());
        for (LibraryDependencyImpl libImpl : libs) {
            AndroidLibrary clonedLib = DependenciesImpl.getAndroidLibrary((LibraryDependency)libImpl);
            libraries.add(clonedLib);
        }
        List<JarDependency> jarDeps = variantDependencies.getJarDependencies();
        List<JarDependency> localDeps = variantDependencies.getLocalDependencies();
        ArrayList javaLibraries = Lists.newArrayListWithExpectedSize((int)(jarDeps.size() + localDeps.size()));
        ArrayList projects = Lists.newArrayList();
        for (JarDependency jarDep : jarDeps) {
            if (!jarDep.isCompiled()) continue;
            boolean customArtifact = jarDep.getResolvedCoordinates() != null && jarDep.getResolvedCoordinates().getClassifier() != null;
            File jarFile = jarDep.getJarFile();
            if (!customArtifact && jarDep.getProjectPath() != null) {
                projects.add(jarDep.getProjectPath());
                continue;
            }
            javaLibraries.add(new JavaLibraryImpl(jarFile, null, jarDep.getResolvedCoordinates()));
        }
        for (JarDependency jarDep : localDeps) {
            if (!jarDep.isCompiled()) continue;
            javaLibraries.add(new JavaLibraryImpl(jarDep.getJarFile(), null, jarDep.getResolvedCoordinates()));
        }
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        if (variantConfig.getRenderscriptSupportModeEnabled() && (supportJar = androidBuilder.getRenderScriptSupportJar()) != null) {
            javaLibraries.add(new JavaLibraryImpl(supportJar, null, null));
        }
        return new DependenciesImpl(libraries, javaLibraries, projects);
    }

    public DependenciesImpl(@NonNull Set<JavaLibrary> javaLibraries) {
        this.javaLibraries = Lists.newArrayList(javaLibraries);
        this.libraries = Collections.emptyList();
        this.projects = Collections.emptyList();
    }

    private DependenciesImpl(@NonNull List<AndroidLibrary> libraries, @NonNull List<JavaLibrary> javaLibraries, @NonNull List<String> projects) {
        this.libraries = libraries;
        this.javaLibraries = javaLibraries;
        this.projects = projects;
    }

    @NonNull
    public Collection<AndroidLibrary> getLibraries() {
        return this.libraries;
    }

    @NonNull
    public Collection<JavaLibrary> getJavaLibraries() {
        return this.javaLibraries;
    }

    @NonNull
    public List<String> getProjects() {
        return this.projects;
    }

    @NonNull
    private static AndroidLibrary getAndroidLibrary(@NonNull LibraryDependency libraryDependency) {
        List deps = libraryDependency.getDependencies();
        ArrayList clonedDeps = Lists.newArrayListWithCapacity((int)deps.size());
        for (LibraryDependency child : deps) {
            AndroidLibrary clonedLib = DependenciesImpl.getAndroidLibrary(child);
            clonedDeps.add(clonedLib);
        }
        Collection<File> localJarOverride = DependenciesImpl.findLocalJar(libraryDependency);
        return new AndroidLibraryImpl(libraryDependency, clonedDeps, localJarOverride, libraryDependency.getProject(), libraryDependency.getProjectVariant(), libraryDependency.getRequestedCoordinates(), libraryDependency.getResolvedCoordinates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static Collection<File> findLocalJar(LibraryDependency library) {
        File explodedFolder = library.getFolder();
        if (explodedFolder.isDirectory()) {
            return library.getLocalJars();
        }
        File aarFile = library.getBundle();
        if (aarFile.isFile()) {
            ArrayList jarList = Lists.newArrayList();
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(aarFile);
                Object e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry zipEntry = e.nextElement();
                    String name = zipEntry.getName();
                    if (!name.startsWith("libs/") || !name.endsWith(".jar")) continue;
                    jarList.add(new File(explodedFolder, name.replace('/', File.separatorChar)));
                }
                e = jarList;
                return e;
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException e) {
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        return Collections.emptyList();
    }
}

