/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.model.ProductFlavorImpl;
import com.android.build.gradle.internal.model.SourceProviderContainerImpl;
import com.android.build.gradle.internal.model.SourceProviderImpl;
import com.android.builder.core.VariantType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

class ProductFlavorContainerImpl
implements ProductFlavorContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final ProductFlavor productFlavor;
    @NonNull
    private final SourceProvider sourceProvider;
    @NonNull
    private final Collection<SourceProviderContainer> extraSourceProviders;

    @NonNull
    static ProductFlavorContainer createProductFlavorContainer(@NonNull ProductFlavorData productFlavorData, @NonNull Collection<SourceProviderContainer> sourceProviderContainers) {
        List<SourceProviderContainer> clonedContainers = SourceProviderContainerImpl.cloneCollection(sourceProviderContainers);
        for (VariantType variantType : VariantType.getTestingTypes()) {
            clonedContainers.add(SourceProviderContainerImpl.create(variantType.getArtifactName(), productFlavorData.getTestSourceSet(variantType)));
        }
        return new ProductFlavorContainerImpl(ProductFlavorImpl.cloneFlavor(productFlavorData.getProductFlavor(), null, null), SourceProviderImpl.cloneProvider(productFlavorData.getSourceSet()), clonedContainers);
    }

    private ProductFlavorContainerImpl(@NonNull ProductFlavorImpl productFlavor, @NonNull SourceProviderImpl sourceProvider, @NonNull Collection<SourceProviderContainer> extraSourceProviders) {
        this.productFlavor = productFlavor;
        this.sourceProvider = sourceProvider;
        this.extraSourceProviders = extraSourceProviders;
    }

    @NonNull
    public ProductFlavor getProductFlavor() {
        return this.productFlavor;
    }

    @NonNull
    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    @NonNull
    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.extraSourceProviders;
    }
}

