/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.tooling.internal.provider.events.AbstractTestResult;
import org.gradle.tooling.internal.provider.events.DefaultFailure;
import org.gradle.tooling.internal.provider.events.DefaultTestDescriptor;
import org.gradle.tooling.internal.provider.events.DefaultTestFailureResult;
import org.gradle.tooling.internal.provider.events.DefaultTestFinishedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTestSkippedResult;
import org.gradle.tooling.internal.provider.events.DefaultTestStartedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTestSuccessResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientForwardingTestListener
implements TestListenerInternal {
    private final BuildEventConsumer eventConsumer;

    ClientForwardingTestListener(BuildEventConsumer eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
        this.eventConsumer.dispatch((Object)new DefaultTestStartedProgressEvent(startEvent.getStartTime(), ClientForwardingTestListener.adapt(testDescriptor)));
    }

    public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
        this.eventConsumer.dispatch((Object)new DefaultTestFinishedProgressEvent(completeEvent.getEndTime(), ClientForwardingTestListener.adapt(testDescriptor), ClientForwardingTestListener.adapt(testResult)));
    }

    public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
    }

    private static DefaultTestDescriptor adapt(TestDescriptorInternal testDescriptor) {
        return testDescriptor.isComposite() ? ClientForwardingTestListener.toTestDescriptorForSuite(testDescriptor) : ClientForwardingTestListener.toTestDescriptorForTest(testDescriptor);
    }

    private static DefaultTestDescriptor toTestDescriptorForSuite(TestDescriptorInternal suite) {
        Object id = suite.getId();
        String name = suite.getName();
        String displayName = suite.toString();
        String testKind = "SUITE";
        String suiteName = suite.getName();
        String className = suite.getClassName();
        String methodName = null;
        Object parentId = suite.getParent() != null ? suite.getParent().getId() : null;
        return new DefaultTestDescriptor(id, name, displayName, testKind, suiteName, className, methodName, parentId);
    }

    private static DefaultTestDescriptor toTestDescriptorForTest(TestDescriptorInternal test) {
        Object id = test.getId();
        String name = test.getName();
        String displayName = test.toString();
        String testKind = "ATOMIC";
        String suiteName = null;
        String className = test.getClassName();
        String methodName = test.getName();
        Object parentId = test.getParent() != null ? test.getParent().getId() : null;
        return new DefaultTestDescriptor(id, name, displayName, testKind, suiteName, className, methodName, parentId);
    }

    private static AbstractTestResult adapt(TestResult result) {
        TestResult.ResultType resultType = result.getResultType();
        switch (resultType) {
            case SUCCESS: {
                return new DefaultTestSuccessResult(result.getStartTime(), result.getEndTime());
            }
            case SKIPPED: {
                return new DefaultTestSkippedResult(result.getStartTime(), result.getEndTime());
            }
            case FAILURE: {
                return new DefaultTestFailureResult(result.getStartTime(), result.getEndTime(), ClientForwardingTestListener.convertExceptions(result.getExceptions()));
            }
        }
        throw new IllegalStateException("Unknown test result type: " + resultType);
    }

    private static List<DefaultFailure> convertExceptions(List<Throwable> exceptions) {
        ArrayList<DefaultFailure> failures = new ArrayList<DefaultFailure>(exceptions.size());
        for (Throwable exception : exceptions) {
            failures.add(DefaultFailure.fromThrowable((Throwable)exception));
        }
        return failures;
    }
}

