/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import java.util.Date;
import javax.swing.Icon;

public abstract class Task {
    public static Task[] EMPTY_ARRAY = new Task[0];

    public abstract String getId();

    public abstract String getSummary();

    public abstract String getDescription();

    public abstract Comment[] getComments();

    public abstract Icon getIcon();

    public abstract TaskType getType();

    public abstract Date getUpdated();

    public abstract Date getCreated();

    public abstract boolean isClosed();

    public String getCustomIcon() {
        return null;
    }

    public abstract boolean isIssue();

    public abstract String getIssueUrl();

    public TaskRepository getRepository() {
        return null;
    }

    public TaskState getState() {
        return null;
    }

    public final String toString() {
        String text = this.isIssue() ? this.getId() + ": " + this.getSummary() : this.getSummary();
        return StringUtil.first((String)text, (int)60, (boolean)true);
    }

    public String getPresentableName() {
        return this.toString();
    }

    public final boolean equals(Object obj) {
        return obj instanceof Task && ((Task)obj).getId().equals(this.getId());
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public String getNumber() {
        return Task.extractNumberFromId(this.getId());
    }

    protected static String extractNumberFromId(String id) {
        int i = id.lastIndexOf(45);
        return i > 0 ? id.substring(i + 1) : id;
    }

    public String getProject() {
        return Task.extractProjectFromId(this.getId());
    }

    protected static String extractProjectFromId(String id) {
        int i = id.lastIndexOf(45);
        return i > 0 ? id.substring(0, i) : null;
    }
}

