/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;

@Tag(value="server")
public abstract class TaskRepository {
    protected static final int NO_FEATURES = 0;
    public static final int BASIC_HTTP_AUTHORIZATION = 1;
    public static final int LOGIN_ANONYMOUSLY = 2;
    public static final int TIME_MANAGEMENT = 4;
    public static final int STATE_UPDATING = 8;
    public static final int NATIVE_SEARCH = 16;
    private boolean myShared;
    private String myUrl = "";
    private TaskRepositoryType myType;
    protected boolean myShouldFormatCommitMessage;
    protected String myCommitMessageFormat = "{id} {summary}";

    @Attribute(value="url")
    public String getUrl() {
        return TaskRepository.trimTrailingSlashes(this.myUrl);
    }

    public void setUrl(String url) {
        this.myUrl = TaskRepository.trimTrailingSlashes(url);
    }

    public boolean isConfigured() {
        return StringUtil.isNotEmpty((String)this.getUrl());
    }

    @Attribute(value="shared")
    public boolean isShared() {
        return this.myShared;
    }

    public void setShared(boolean shared) {
        this.myShared = shared;
    }

    public String getPresentableName() {
        return StringUtil.isEmpty((String)this.getUrl()) ? "<undefined>" : this.getUrl();
    }

    public Icon getIcon() {
        return this.getRepositoryType().getIcon();
    }

    public void testConnection() throws Exception {
    }

    public CancellableConnection createCancellableConnection() {
        return null;
    }

    @Deprecated
    public Task[] getIssues(String query, int max, long since) throws Exception {
        throw new UnsupportedOperationException("Deprecated: should not be called");
    }

    @Deprecated
    public Task[] getIssues(String query, int max, long since, ProgressIndicator cancelled) throws Exception {
        return this.getIssues(query, max, since);
    }

    public Task[] getIssues(String query, int offset, int limit, boolean withClosed) throws Exception {
        return this.getIssues(query, offset + limit, 0L);
    }

    public Task[] getIssues(String query, int offset, int limit, boolean withClosed, ProgressIndicator cancelled) throws Exception {
        return this.getIssues(query, offset, limit, withClosed);
    }

    public Set<CustomTaskState> getAvailableTaskStates(Task task) throws Exception {
        return ContainerUtil.map2Set(this.getRepositoryType().getPossibleTaskStates(), (Function)new Function<TaskState, CustomTaskState>(){

            public CustomTaskState fun(TaskState state) {
                return CustomTaskState.fromPredefined(state);
            }
        });
    }

    public abstract void setPreferredOpenTaskState(CustomTaskState var1);

    public abstract CustomTaskState getPreferredOpenTaskState();

    public abstract void setPreferredCloseTaskState(CustomTaskState var1);

    public abstract CustomTaskState getPreferredCloseTaskState();

    public abstract Task findTask(String var1) throws Exception;

    public abstract TaskRepository clone();

    public abstract String extractId(String var1);

    @Deprecated
    public void setTaskState(Task task, TaskState state) throws Exception {
        throw new UnsupportedOperationException("Setting task to state " + (Object)((Object)state) + " is not supported");
    }

    public void setTaskState(Task task, CustomTaskState state) throws Exception {
        if (state.isPredefined()) {
            this.setTaskState(task, state.asPredefined());
        }
    }

    public TaskRepository() {
        this.myType = null;
    }

    public TaskRepository(TaskRepositoryType type) {
        this.myType = type;
    }

    protected TaskRepository(TaskRepository other) {
        this.myType = other.myType;
        this.myShared = other.isShared();
        this.myUrl = other.getUrl();
        this.setShouldFormatCommitMessage(other.myShouldFormatCommitMessage);
        this.setCommitMessageFormat(other.myCommitMessageFormat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskRepository)) {
            return false;
        }
        TaskRepository that = (TaskRepository)o;
        if (!Comparing.equal((Object)this.myType, (Object)that.myType)) {
            return false;
        }
        if (this.isShared() != that.isShared()) {
            return false;
        }
        if (this.getUrl() != null ? !this.getUrl().equals(that.getUrl()) : that.getUrl() != null) {
            return false;
        }
        if (this.getCommitMessageFormat() != null ? !this.getCommitMessageFormat().equals(that.getCommitMessageFormat()) : that.getCommitMessageFormat() != null) {
            return false;
        }
        return this.isShouldFormatCommitMessage() == that.isShouldFormatCommitMessage();
    }

    @Transient
    public final TaskRepositoryType getRepositoryType() {
        return this.myType;
    }

    public final void setRepositoryType(TaskRepositoryType type) {
        this.myType = type;
    }

    public boolean isShouldFormatCommitMessage() {
        return this.myShouldFormatCommitMessage;
    }

    public void setShouldFormatCommitMessage(boolean shouldFormatCommitMessage) {
        this.myShouldFormatCommitMessage = shouldFormatCommitMessage;
    }

    @Tag(value="commitMessageFormat")
    public String getCommitMessageFormat() {
        return this.myCommitMessageFormat;
    }

    public void setCommitMessageFormat(String commitMessageFormat) {
        this.myCommitMessageFormat = commitMessageFormat;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(URL='" + this.myUrl + "')";
    }

    private static String trimTrailingSlashes(String url) {
        if (url == null) {
            return "";
        }
        for (int i = url.length() - 1; i >= 0; --i) {
            if (url.charAt(i) == '/') continue;
            return url.substring(0, i + 1);
        }
        return "";
    }

    public String getTaskComment(Task task) {
        return this.isShouldFormatCommitMessage() ? this.myCommitMessageFormat.replace("{id}", task.getId()).replace("{summary}", task.getSummary()) : null;
    }

    public String getComment() {
        return "{id} (e.g. FOO-001), {summary}, {number} (e.g. 001), {project} (e.g. FOO)";
    }

    public void updateTimeSpent(LocalTask task, String timeSpent, String comment) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean isSupported(int feature) {
        return (this.getFeatures() & feature) != 0;
    }

    protected int getFeatures() {
        return 16;
    }

    public static abstract class CancellableConnection
    implements Callable<Exception> {
        @Override
        public final Exception call() {
            try {
                this.doTest();
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }

        protected abstract void doTest() throws Exception;

        public abstract void cancel();
    }
}

