/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration.browser;

import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class GroupList
extends JPanel {
    private final JList list;

    public GroupList(PsiClass[] classes) {
        super(new BorderLayout());
        SortedListModel model = new SortedListModel((Comparator)new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        this.list = new JBList((ListModel)model);
        Set<String> groups = TestNGUtil.getAnnotationValues("groups", classes);
        Object[] array = ArrayUtil.toStringArray(groups);
        Arrays.sort(array);
        model.addAll(array);
        this.add(ScrollPaneFactory.createScrollPane((Component)this.list));
        this.list.setSelectionMode(0);
        ListScrollingUtil.ensureSelectionExists((JList)this.list);
    }

    public String getSelected() {
        return (String)this.list.getSelectedValue();
    }

    public static String showDialog(PsiClass[] classes, JComponent component) {
        GroupList groupList = new GroupList(classes);
        DialogBuilder builder = new DialogBuilder((Component)component);
        builder.setCenterPanel((JComponent)groupList);
        builder.setPreferredFocusComponent((JComponent)groupList.list);
        builder.setTitle("Choose Test Group");
        return builder.show() != 0 ? null : groupList.getSelected();
    }
}

