/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.TypeUtils;

public class AssertEqualsBetweenInconvertibleTypesTestNGInspection
extends BaseJavaBatchLocalInspectionTool {
    public PsiElementVisitor buildVisitor(ProblemsHolder holder, boolean isOnTheFly) {
        return new AssertEqualsBetweenInconvertibleTypesVisitor(holder);
    }

    private static class AssertEqualsBetweenInconvertibleTypesVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myProblemsHolder;

        public AssertEqualsBetweenInconvertibleTypesVisitor(ProblemsHolder problemsHolder) {
            this.myProblemsHolder = problemsHolder;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            GlobalSearchScope scope;
            PsiType parameterType2;
            PsiType parameterType1;
            PsiExpression expression2;
            PsiExpression expression1;
            boolean junit;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"assertEquals".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.testng.Assert")) {
                junit = false;
            } else if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.testng.AssertJUnit")) {
                junit = true;
            } else {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length < 2) {
                return;
            }
            PsiType firstParameterType = parameters[0].getType();
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (junit && firstParameterType.equalsToText("java.lang.String")) {
                if (arguments.length < 3) {
                    return;
                }
                expression1 = arguments[1];
                expression2 = arguments[2];
                parameterType1 = parameters[1].getType();
                parameterType2 = parameters[2].getType();
            } else {
                if (arguments.length < 2) {
                    return;
                }
                expression1 = arguments[0];
                expression2 = arguments[1];
                parameterType1 = parameters[0].getType();
                parameterType2 = parameters[1].getType();
            }
            PsiType type1 = expression1.getType();
            if (type1 == null) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            PsiManager manager = expression.getManager();
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)(scope = expression.getResolveScope()));
            if (!objectType.equals((Object)parameterType1) || !objectType.equals((Object)parameterType2)) {
                return;
            }
            if (TypeUtils.areConvertible((PsiType)type1, (PsiType)type2)) {
                return;
            }
            PsiElement referenceNameElement = methodExpression.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            this.myProblemsHolder.registerProblem(referenceNameElement, "<code>#ref()</code> between objects of inconvertible types '" + StringUtil.escapeXml((String)type1.getPresentableText()) + "' and '" + StringUtil.escapeXml((String)type2.getPresentableText()) + "' #loc", new LocalQuickFix[0]);
        }
    }
}

