/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class AssertsWithoutMessagesTestNGInspection
extends BaseJavaLocalInspectionTool {
    public PsiElementVisitor buildVisitor(ProblemsHolder holder, boolean isOnTheFly) {
        return new AssertionsWithoutMessagesVisitor(holder);
    }

    private static class AssertionsWithoutMessagesVisitor
    extends JavaElementVisitor {
        @NonNls
        private static final Set<String> ourAssertMethods = new HashSet<String>(10);
        private final ProblemsHolder myProblemsHolder;

        public AssertionsWithoutMessagesVisitor(ProblemsHolder problemsHolder) {
            this.myProblemsHolder = problemsHolder;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            boolean messageFirst;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null || !ourAssertMethods.contains(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.testng.AssertJUnit")) {
                messageFirst = true;
            } else if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.testng.Assert")) {
                messageFirst = false;
            } else {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount < 2 && methodName.startsWith("assert")) {
                this.registerMethodCallError(expression);
                return;
            }
            if (parameterCount < 1) {
                this.registerMethodCallError(expression);
                return;
            }
            PsiManager psiManager = expression.getManager();
            Project project = psiManager.getProject();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClassType stringType = PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)scope);
            PsiParameter[] parameters = parameterList.getParameters();
            if (messageFirst) {
                PsiType parameterType2;
                PsiType parameterType1 = parameters[0].getType();
                if (!stringType.equals(parameterType1)) {
                    this.registerMethodCallError(expression);
                    return;
                }
                if (parameters.length == 2 && stringType.equals(parameterType2 = parameters[1].getType())) {
                    this.registerMethodCallError(expression);
                }
            } else {
                PsiType firstParameterType;
                PsiType lastParameterType = parameters[parameters.length - 1].getType();
                if (!stringType.equals(lastParameterType)) {
                    this.registerMethodCallError(expression);
                    return;
                }
                if (parameters.length == 2 && stringType.equals(firstParameterType = parameters[0].getType())) {
                    this.registerMethodCallError(expression);
                }
            }
        }

        private void registerMethodCallError(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiElement nameElement = methodExpression.getReferenceNameElement();
            if (nameElement == null) {
                this.myProblemsHolder.registerProblem((PsiElement)methodExpression, "TestNG <code>#ref()</code> without message #loc", new LocalQuickFix[0]);
            } else {
                this.myProblemsHolder.registerProblem(nameElement, "TestNG <code>#ref()</code> without message #loc", new LocalQuickFix[0]);
            }
        }

        static {
            ourAssertMethods.add("assertArrayEquals");
            ourAssertMethods.add("assertEquals");
            ourAssertMethods.add("assertEqualsNoOrder");
            ourAssertMethods.add("assertFalse");
            ourAssertMethods.add("assertNotEquals");
            ourAssertMethods.add("assertNotNull");
            ourAssertMethods.add("assertNotSame");
            ourAssertMethods.add("assertNull");
            ourAssertMethods.add("assertSame");
            ourAssertMethods.add("assertTrue");
            ourAssertMethods.add("fail");
        }
    }
}

