/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.intention;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NonNls;
import org.testng.annotations.Test;

public class TestNGOrderEntryFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + TestNGOrderEntryFix.class.getName()));

    public String getText() {
        return "Add testng.jar to classpath";
    }

    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (!file.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        PsiReference reference = TargetElementUtilBase.findReference((Editor)editor);
        if (!(reference instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        if (reference.resolve() != null) {
            return false;
        }
        String referenceName = ((PsiJavaCodeReferenceElement)reference).getReferenceName();
        if (referenceName == null) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (fileIndex.getModuleForFile(virtualFile) == null) {
            return false;
        }
        if (!(((PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiAnnotation) || !PsiUtil.isLanguageLevel5OrHigher((PsiElement)((PsiJavaCodeReferenceElement)reference))) {
            return false;
        }
        return TestNGOrderEntryFix.isTestNGAnnotationName(referenceName);
    }

    public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)TargetElementUtilBase.findReference((Editor)editor);
        LOG.assertTrue(reference != null);
        String jarPath = PathUtil.getJarPathForClass(Test.class);
        VirtualFile virtualFile = file.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        OrderEntryFix.addBundledJarToRoots((Project)project, (Editor)editor, (Module)ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project), (PsiReference)reference, (String)("org.testng.annotations." + reference.getReferenceName()), (String)jarPath);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static boolean isTestNGAnnotationName(@NonNls String referenceName) {
        return "Test".equals(referenceName) || "BeforeClass".equals(referenceName) || "BeforeGroups".equals(referenceName) || "BeforeMethod".equals(referenceName) || "BeforeSuite".equals(referenceName) || "BeforeTest".equals(referenceName) || "AfterClass".equals(referenceName) || "AfterGroups".equals(referenceName) || "AfterMethod".equals(referenceName) || "AfterSuite".equals(referenceName) || "AfterTest".equals(referenceName) || "Configuration".equals(referenceName);
    }
}

