/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.ui.actions;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.actions.JavaRerunFailedTestsAction;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.configuration.SearchingForTestsTask;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGRunnableState;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.io.File;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RerunFailedTestsAction
extends JavaRerunFailedTestsAction {
    public RerunFailedTestsAction(ComponentContainer componentContainer, TestConsoleProperties consoleProperties) {
        super(componentContainer, consoleProperties);
    }

    protected AbstractRerunFailedTestsAction.MyRunProfile getRunProfile(ExecutionEnvironment environment) {
        final TestNGConfiguration configuration = (TestNGConfiguration)this.getModel().getProperties().getConfiguration();
        final List failedTests = this.getFailedTests(configuration.getProject());
        return new AbstractRerunFailedTestsAction.MyRunProfile((RunConfigurationBase)configuration){

            public Module[] getModules() {
                return configuration.getModules();
            }

            public RunProfileState getState(Executor executor, ExecutionEnvironment env) {
                return new TestNGRunnableState(env, configuration){

                    @Override
                    protected SearchingForTestsTask createSearchingForTestsTask(ServerSocket serverSocket, final TestNGConfiguration config, File tempFile) {
                        return new SearchingForTestsTask(serverSocket, config, tempFile, this.client){

                            @Override
                            protected void fillTestObjects(Map<PsiClass, Collection<PsiMethod>> classes) throws CantRunException {
                                HashMap fullClassList = ContainerUtil.newHashMap();
                                super.fillTestObjects(fullClassList);
                                for (final PsiClass aClass : fullClassList.keySet()) {
                                    if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                                        public Boolean compute() {
                                            return TestNGUtil.hasTest((PsiModifierListOwner)aClass);
                                        }
                                    })).booleanValue()) continue;
                                    classes.put(aClass, (Collection<PsiMethod>)fullClassList.get(aClass));
                                }
                                GlobalSearchScope scope = ((JavaRunConfigurationModule)config.getConfigurationModule()).getSearchScope();
                                Project project = config.getProject();
                                for (AbstractTestProxy proxy : failedTests) {
                                    Collection<PsiMethod> psiMethods;
                                    PsiElement element;
                                    Location location = proxy.getLocation(project, scope);
                                    if (location == null || !((element = location.getPsiElement()) instanceof PsiMethod) || !element.isValid()) continue;
                                    PsiMethod psiMethod = (PsiMethod)element;
                                    PsiClass psiClass = psiMethod.getContainingClass();
                                    if (psiClass != null && psiClass.hasModifierProperty("abstract")) {
                                        PsiElement elt;
                                        AbstractTestProxy parent = proxy.getParent();
                                        PsiElement psiElement = elt = parent != null ? parent.getLocation(project, scope).getPsiElement() : null;
                                        if (elt instanceof PsiClass) {
                                            psiClass = (PsiClass)elt;
                                        }
                                    }
                                    if ((psiMethods = classes.get(psiClass)) == null) {
                                        psiMethods = new ArrayList<PsiMethod>();
                                        classes.put(psiClass, psiMethods);
                                    }
                                    psiMethods.add(psiMethod);
                                }
                            }
                        };
                    }
                };
            }
        };
    }
}

