/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.maven;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.buildinit.plugins.internal.maven.MavenConversionException;
import org.gradle.internal.SystemProperties;
import org.gradle.mvn3.org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.gradle.mvn3.org.apache.maven.execution.DefaultMavenExecutionResult;
import org.gradle.mvn3.org.apache.maven.execution.MavenExecutionRequest;
import org.gradle.mvn3.org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.gradle.mvn3.org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.gradle.mvn3.org.apache.maven.execution.MavenExecutionResult;
import org.gradle.mvn3.org.apache.maven.execution.MavenSession;
import org.gradle.mvn3.org.apache.maven.project.MavenProject;
import org.gradle.mvn3.org.apache.maven.project.ProjectBuilder;
import org.gradle.mvn3.org.apache.maven.project.ProjectBuildingException;
import org.gradle.mvn3.org.apache.maven.project.ProjectBuildingRequest;
import org.gradle.mvn3.org.apache.maven.project.ProjectBuildingResult;
import org.gradle.mvn3.org.apache.maven.settings.Settings;
import org.gradle.mvn3.org.codehaus.plexus.ContainerConfiguration;
import org.gradle.mvn3.org.codehaus.plexus.DefaultContainerConfiguration;
import org.gradle.mvn3.org.codehaus.plexus.DefaultPlexusContainer;
import org.gradle.mvn3.org.codehaus.plexus.PlexusContainer;
import org.gradle.mvn3.org.codehaus.plexus.PlexusContainerException;
import org.gradle.mvn3.org.codehaus.plexus.classworlds.ClassWorld;
import org.gradle.mvn3.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.mvn3.org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.gradle.mvn3.org.sonatype.aether.RepositorySystemSession;
import org.gradle.mvn3.org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectsCreator {
    public Set<MavenProject> create(Settings mavenSettings, File pomFile) {
        if (!pomFile.exists()) {
            throw new MavenConversionException(String.format("Unable to create Maven project model. The POM file %s does not exist.", pomFile));
        }
        try {
            return this.createNow(mavenSettings, pomFile);
        }
        catch (Exception e) {
            throw new MavenConversionException(String.format("Unable to create Maven project model using POM %s.", pomFile), e);
        }
    }

    private Set<MavenProject> createNow(Settings settings, File pomFile) throws PlexusContainerException, PlexusConfigurationException, ComponentLookupException, MavenExecutionRequestPopulationException, ProjectBuildingException {
        ContainerConfiguration containerConfiguration = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", ClassWorld.class.getClassLoader())).setName("mavenCore");
        DefaultPlexusContainer container = new DefaultPlexusContainer(containerConfiguration);
        ProjectBuilder builder = (ProjectBuilder)container.lookup(ProjectBuilder.class);
        DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)SystemProperties.getInstance().asMap());
        executionRequest.setSystemProperties(properties);
        MavenExecutionRequestPopulator populator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
        populator.populateFromSettings((MavenExecutionRequest)executionRequest, settings);
        populator.populateDefaults((MavenExecutionRequest)executionRequest);
        ProjectBuildingRequest buildingRequest = executionRequest.getProjectBuildingRequest();
        buildingRequest.setProcessPlugins(false);
        MavenProject mavenProject = builder.build(pomFile, buildingRequest).getProject();
        LinkedHashSet<MavenProject> reactorProjects = new LinkedHashSet<MavenProject>();
        reactorProjects.add(mavenProject);
        List allProjects = builder.build((List)ImmutableList.of((Object)pomFile), true, buildingRequest);
        CollectionUtils.collect((Iterable)allProjects, reactorProjects, (Transformer)new Transformer<MavenProject, ProjectBuildingResult>(){

            public MavenProject transform(ProjectBuildingResult original) {
                return original.getProject();
            }
        });
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        result.setProject(mavenProject);
        DefaultRepositorySystemSession repoSession = new DefaultRepositorySystemSession();
        MavenSession session = new MavenSession((PlexusContainer)container, (RepositorySystemSession)repoSession, (MavenExecutionRequest)executionRequest, (MavenExecutionResult)result);
        session.setCurrentProject(mavenProject);
        return reactorProjects;
    }
}

