/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.PreprocessingTool;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.language.nativeplatform.tasks.AbstractNativePCHCompileTask;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.ObjectFile;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.Tool;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.platform.base.BinarySpec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileTaskConfig
implements SourceTransformTaskConfig {
    private final LanguageTransform<? extends LanguageSourceSet, ObjectFile> languageTransform;
    private final Class<? extends DefaultTask> taskType;

    public CompileTaskConfig(LanguageTransform<? extends LanguageSourceSet, ObjectFile> languageTransform, Class<? extends DefaultTask> taskType) {
        this.languageTransform = languageTransform;
        this.taskType = taskType;
    }

    public String getTaskPrefix() {
        return "compile";
    }

    public Class<? extends DefaultTask> getTaskType() {
        return this.taskType;
    }

    public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet) {
        this.configureCompileTaskCommon((AbstractNativeCompileTask)task, (NativeBinarySpecInternal)binary, (LanguageSourceSetInternal)sourceSet);
        this.configureCompileTask((AbstractNativeCompileTask)task, (NativeBinarySpecInternal)binary, (LanguageSourceSetInternal)sourceSet);
    }

    private void configureCompileTaskCommon(AbstractNativeCompileTask task, final NativeBinarySpecInternal binary, final LanguageSourceSetInternal sourceSet) {
        task.setToolChain(binary.getToolChain());
        task.setTargetPlatform(binary.getTargetPlatform());
        task.setPositionIndependentCode(binary instanceof SharedLibraryBinarySpec);
        task.includes(new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return ((HeaderExportingSourceSet)sourceSet).getExportedHeaders().getSrcDirs();
            }
        });
        task.includes(new Callable<List<FileCollection>>(){

            @Override
            public List<FileCollection> call() {
                Collection libs = binary.getLibs((DependentSourceSet)sourceSet);
                return CollectionUtils.collect((Iterable)libs, (Transformer)new Transformer<FileCollection, NativeDependencySet>(){

                    public FileCollection transform(NativeDependencySet original) {
                        return original.getIncludeRoots();
                    }
                });
            }
        });
        for (String toolName : this.languageTransform.getBinaryTools().keySet()) {
            Tool tool = (Tool)((ExtensionAware)binary).getExtensions().getByName(toolName);
            if (tool instanceof PreprocessingTool) {
                task.setMacros(((PreprocessingTool)tool).getMacros());
            }
            task.setCompilerArgs(tool.getArgs());
        }
    }

    protected void configureCompileTask(AbstractNativeCompileTask task, final NativeBinarySpecInternal binary, final LanguageSourceSetInternal sourceSet) {
        task.setDescription(String.format("Compiles the %s of %s", sourceSet, binary));
        task.source(sourceSet.getSource());
        Project project = task.getProject();
        task.setObjectFileDir(project.file((Object)(String.valueOf(project.getBuildDir()) + "/objs/" + binary.getNamingScheme().getOutputDirectoryBase() + "/" + sourceSet.getFullName())));
        if (sourceSet instanceof DependentSourceSet && !((DependentSourceSet)sourceSet).getPreCompiledHeaders().isEmpty()) {
            task.setPrefixHeaderFile(((DependentSourceSet)sourceSet).getPrefixHeaderFile());
            task.setPreCompiledHeaders(((DependentSourceSet)sourceSet).getPreCompiledHeaders());
            task.preCompiledHeaderInclude(new Callable<FileCollection>(){

                @Override
                public FileCollection call() {
                    DomainObjectSet pchTasks = binary.getTasks().withType(AbstractNativePCHCompileTask.class).matching((Spec)new Spec<AbstractNativePCHCompileTask>(){

                        public boolean isSatisfiedBy(AbstractNativePCHCompileTask pchCompileTask) {
                            return ((DependentSourceSet)sourceSet).getPrefixHeaderFile().equals(pchCompileTask.getPrefixHeaderFile());
                        }
                    });
                    if (!pchTasks.isEmpty()) {
                        return ((AbstractNativePCHCompileTask)((Object)pchTasks.iterator().next())).getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.pch", "**/*.gch"}));
                    }
                    return new SimpleFileCollection(new File[0]);
                }
            });
        }
        binary.binaryInputs((FileCollection)task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
    }
}

