/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.specs.Spec;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.language.nativeplatform.internal.CompileTaskConfig;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.nativeplatform.ObjectFile;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.tasks.PrefixHeaderFileGenerateTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCHCompileTaskConfig
extends CompileTaskConfig {
    public PCHCompileTaskConfig(LanguageTransform<? extends LanguageSourceSet, ObjectFile> languageTransform, Class<? extends DefaultTask> taskType) {
        super(languageTransform, taskType);
    }

    @Override
    protected void configureCompileTask(AbstractNativeCompileTask task, NativeBinarySpecInternal binary, LanguageSourceSetInternal languageSourceSet) {
        final DependentSourceSet sourceSet = (DependentSourceSet)languageSourceSet;
        task.setDescription(String.format("Compiles a pre-compiled header for the %s of %s", sourceSet, binary));
        Project project = task.getProject();
        task.setPrefixHeaderFile(sourceSet.getPrefixHeaderFile());
        task.setPreCompiledHeaders(sourceSet.getPreCompiledHeaders());
        task.source(sourceSet.getPrefixHeaderFile());
        task.setObjectFileDir(project.file((Object)(String.valueOf(project.getBuildDir()) + "/objs/" + binary.getNamingScheme().getOutputDirectoryBase() + "/" + languageSourceSet.getFullName() + "PreCompiledHeader")));
        task.dependsOn(new Object[]{project.getTasks().withType(PrefixHeaderFileGenerateTask.class).matching((Spec)new Spec<PrefixHeaderFileGenerateTask>(){

            public boolean isSatisfiedBy(PrefixHeaderFileGenerateTask prefixHeaderFileGenerateTask) {
                return prefixHeaderFileGenerateTask.getPrefixHeaderFile().equals(sourceSet.getPrefixHeaderFile());
            }
        })});
    }
}

