/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.binary;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Namespace;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Decoder {
    private final TIntObjectHashMap<BinaryObject> mObjects = new TIntObjectHashMap();
    private final TIntObjectHashMap<BinaryID> mIDs = new TIntObjectHashMap();
    private final InputStream mInputStream;
    private final byte[] mBuffer;

    public Decoder(InputStream in) {
        this.mInputStream = in;
        this.mBuffer = new byte[9];
    }

    public void read(byte[] buf, int count) throws IOException {
        for (int off = 0; off < count; off += this.mInputStream.read(buf, off, count - off)) {
        }
    }

    private void read(int count) throws IOException {
        this.read(this.mBuffer, count);
    }

    public boolean bool() throws IOException {
        this.read(1);
        return this.mBuffer[0] != 0;
    }

    public byte int8() throws IOException {
        this.read(1);
        return this.mBuffer[0];
    }

    public byte uint8() throws IOException {
        return this.int8();
    }

    private long intv() throws IOException {
        long uv = this.uintv();
        long v = uv >>> 1;
        if ((uv & 1L) != 0L) {
            v ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return v;
    }

    private long uintv() throws IOException {
        this.read(1);
        int count = 0;
        while ((128 >> count & this.mBuffer[0]) != 0) {
            ++count;
        }
        long v = this.mBuffer[0] & 255 >> count;
        if (count == 0) {
            return v;
        }
        this.read(count);
        for (int i = 0; i < count; ++i) {
            v = v << 8 | (long)this.mBuffer[i] & 0xFFL;
        }
        return v;
    }

    public short int16() throws IOException {
        return (short)this.intv();
    }

    public short uint16() throws IOException {
        return (short)this.uintv();
    }

    public int int32() throws IOException {
        return (int)this.intv();
    }

    public int uint32() throws IOException {
        return (int)this.uintv();
    }

    public long int64() throws IOException {
        return this.intv();
    }

    public long uint64() throws IOException {
        return this.uintv();
    }

    public float float32() throws IOException {
        int bits = (int)this.uintv();
        int shuffled = (bits & 0xFF) << 24 | (bits & 0xFF00) << 8 | (bits & 0xFF0000) >> 8 | (bits & 0xFF000000) >>> 24;
        return Float.intBitsToFloat(shuffled);
    }

    public double float64() throws IOException {
        long bits = this.uintv();
        long shuffled = (bits & 0xFFL) << 56 | (bits & 0xFF00L) << 40 | (bits & 0xFF0000L) << 24 | (bits & 0xFF000000L) << 8 | (bits & 0xFF00000000L) >> 8 | (bits & 0xFF0000000000L) >> 24 | (bits & 0xFF000000000000L) >> 40 | (bits & 0xFF00000000000000L) >>> 56;
        return Double.longBitsToDouble(shuffled);
    }

    public String string() throws IOException {
        int size = this.uint32();
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = this.int8();
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public BinaryID id() throws IOException {
        int v = this.uint32();
        int sid = v >> 1;
        if ((v & 1) != 0) {
            BinaryID id = new BinaryID(this);
            this.mIDs.put(sid, (Object)id);
            return id;
        }
        BinaryID id = (BinaryID)this.mIDs.get(sid);
        if (id == null) {
            throw new RuntimeException("Unknown id: " + sid);
        }
        return id;
    }

    public void value(BinaryObject obj) throws IOException {
        obj.klass().decode(this, obj);
    }

    public BinaryObject variant() throws IOException {
        BinaryID id = this.id();
        BinaryClass c = Namespace.lookup(id);
        if (c == null) {
            throw new RuntimeException("Unknown type id: " + id);
        }
        BinaryObject obj = c.create();
        c.decode(this, obj);
        return obj;
    }

    public BinaryObject object() throws IOException {
        int v = this.uint32();
        if (v == 0) {
            return null;
        }
        int sid = v >> 1;
        if ((v & 1) != 0) {
            BinaryObject obj = this.variant();
            this.mObjects.put(sid, (Object)obj);
            return obj;
        }
        return (BinaryObject)this.mObjects.get(sid);
    }

    public InputStream stream() {
        return this.mInputStream;
    }
}

