/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.binary;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Encoder {
    private final OutputStream mOutputStream;
    private final TObjectIntHashMap<BinaryObject> mObjects = new TObjectIntHashMap();
    private final TObjectIntHashMap<BinaryID> mIDs = new TObjectIntHashMap();
    private final byte[] mBuffer;

    public Encoder(OutputStream out) {
        this.mOutputStream = out;
        this.mBuffer = new byte[9];
    }

    public void write(byte[] b, int len) throws IOException {
        this.mOutputStream.write(b, 0, len);
    }

    public void bool(boolean v) throws IOException {
        this.mBuffer[0] = (byte)(v ? 1 : 0);
        this.mOutputStream.write(this.mBuffer, 0, 1);
    }

    public void int8(byte v) throws IOException {
        this.mBuffer[0] = v;
        this.mOutputStream.write(this.mBuffer, 0, 1);
    }

    public void uint8(short v) throws IOException {
        this.mBuffer[0] = (byte)(v & 0xFF);
        this.mOutputStream.write(this.mBuffer, 0, 1);
    }

    private void intv(long v) throws IOException {
        long uv = v << 1;
        if (v < 0L) {
            uv ^= 0xFFFFFFFFFFFFFFFFL;
        }
        this.uintv(uv);
    }

    private void uintv(long v) throws IOException {
        long space = -128L;
        int tag = 0;
        int o = 8;
        while (true) {
            if ((v & space) == 0L) {
                this.mBuffer[o] = (byte)(v | (long)tag);
                this.mOutputStream.write(this.mBuffer, o, 9 - o);
                return;
            }
            this.mBuffer[o] = (byte)(v & 0xFFL);
            v >>>= 8;
            space >>= 1;
            tag = tag >> 1 | 0x80;
            --o;
        }
    }

    public void int16(short v) throws IOException {
        this.intv(v);
    }

    public void uint16(int v) throws IOException {
        this.uintv(v);
    }

    public void int32(int v) throws IOException {
        this.intv(v);
    }

    public void uint32(long v) throws IOException {
        this.uintv(v);
    }

    public void int64(long v) throws IOException {
        this.intv(v);
    }

    public void uint64(long v) throws IOException {
        this.uintv(v);
    }

    public void float32(float v) throws IOException {
        int bits = Float.floatToIntBits(v);
        int shuffled = (bits & 0xFF) << 24 | (bits & 0xFF00) << 8 | (bits & 0xFF0000) >> 8 | (bits & 0xFF000000) >>> 24;
        this.uintv(shuffled);
    }

    public void float64(double v) throws IOException {
        long bits = Double.doubleToLongBits(v);
        long shuffled = (bits & 0xFFL) << 56 | (bits & 0xFF00L) << 40 | (bits & 0xFF0000L) << 24 | (bits & 0xFF000000L) << 8 | (bits & 0xFF00000000L) >> 8 | (bits & 0xFF0000000000L) >> 24 | (bits & 0xFF000000000000L) >> 40 | (bits & 0xFF00000000000000L) >>> 56;
        this.uintv(shuffled);
    }

    public void string(String v) throws IOException {
        try {
            if (v == null) {
                this.uint32(0L);
                return;
            }
            byte[] bytes = v.getBytes("UTF-8");
            this.uint32(bytes.length);
            for (byte b : bytes) {
                this.int8(b);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void id(BinaryID id) throws IOException {
        int sid;
        if (this.mIDs.containsKey((Object)id)) {
            sid = this.mIDs.get((Object)id);
            this.uint32(sid << 1);
        }
        sid = this.mIDs.size() + 1;
        this.mIDs.put((Object)id, sid);
        this.uint32(sid << 1 | 1);
        id.write(this);
    }

    public void value(BinaryObject obj) throws IOException {
        obj.klass().encode(this, obj);
    }

    public void variant(BinaryObject obj) throws IOException {
        if (obj == null) {
            this.id(BinaryID.INVALID);
            return;
        }
        BinaryClass c = obj.klass();
        this.id(c.id());
        c.encode(this, obj);
    }

    public void object(BinaryObject obj) throws IOException {
        if (obj == null) {
            this.uint32(0L);
            return;
        }
        if (this.mObjects.containsKey((Object)obj)) {
            int sid = this.mObjects.get((Object)obj);
            this.uint32(sid << 1);
            return;
        }
        int sid = this.mObjects.size() + 1;
        this.mObjects.put((Object)obj, sid);
        this.uint32(sid << 1 | 1);
        this.variant(obj);
    }

    public OutputStream stream() {
        return this.mOutputStream;
    }
}

