/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.rpccore;

import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.multiplex.Channel;
import com.android.tools.rpclib.multiplex.Multiplexer;
import com.android.tools.rpclib.rpccore.RpcError;
import com.android.tools.rpclib.rpccore.RpcException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;

public class Broadcaster {
    private final Multiplexer mMultiplexer;
    private final int mMtu;

    public Broadcaster(InputStream in, OutputStream out, int mtu, ExecutorService executorService) {
        this.mMultiplexer = new Multiplexer(in, out, mtu, executorService, null);
        this.mMtu = mtu;
    }

    private static void writeHeader(Encoder encoder) throws IOException {
        encoder.int8((byte)114);
        encoder.int8((byte)112);
        encoder.int8((byte)99);
        encoder.int8((byte)48);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryObject Send(BinaryObject call) throws IOException, RpcException {
        Channel channel = this.mMultiplexer.openChannel();
        try {
            BufferedOutputStream out = new BufferedOutputStream(channel.getOutputStream(), this.mMtu);
            Encoder e = new Encoder(out);
            Decoder d = new Decoder(channel.getInputStream());
            Broadcaster.writeHeader(e);
            e.object(call);
            out.flush();
            BinaryObject res = d.object();
            if (res instanceof RpcError) {
                throw new RpcException((RpcError)res);
            }
            BinaryObject binaryObject = res;
            return binaryObject;
        }
        finally {
            channel.close();
        }
    }
}

