/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;

public final class Array
extends Type {
    private String mAlias;
    private Type mValueType;
    private int mSize;
    private static final byte[] IDBytes = new byte[]{122, -120, 62, 9, -21, -57, 92, 44, 105, -62, -101, -99, 60, 93, -37, -28, 63, -64, 126, -58};
    public static final BinaryID ID = new BinaryID(IDBytes);

    @Override
    public String getName() {
        return "array<" + this.mValueType.getName() + ">";
    }

    @Override
    public void encodeValue(Encoder e, Object value) throws IOException {
        assert (value instanceof Object[]);
        Object[] array = (Object[])value;
        for (int i = 0; i < this.mSize; ++i) {
            this.mValueType.encodeValue(e, array[i]);
        }
    }

    @Override
    public Object decodeValue(Decoder d) throws IOException {
        Object[] array = new Object[this.mSize];
        for (int i = 0; i < this.mSize; ++i) {
            array[i] = this.mValueType.decodeValue(d);
        }
        return array;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public Array setAlias(String v) {
        this.mAlias = v;
        return this;
    }

    public Type getValueType() {
        return this.mValueType;
    }

    public Array setValueType(Type v) {
        this.mValueType = v;
        return this;
    }

    public int getSize() {
        return this.mSize;
    }

    public Array setSize(int v) {
        this.mSize = v;
        return this;
    }

    @Override
    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static {
        Namespace.register(ID, Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @Override
        public BinaryID id() {
            return ID;
        }

        @Override
        public BinaryObject create() {
            return new Array();
        }

        @Override
        public void encode(Encoder e, BinaryObject obj) throws IOException {
            Array o = (Array)obj;
            e.string(o.mAlias);
            e.object(o.mValueType.unwrap());
            e.uint32(o.mSize);
        }

        @Override
        public void decode(Decoder d, BinaryObject obj) throws IOException {
            Array o = (Array)obj;
            o.mAlias = d.string();
            o.mValueType = Type.wrap(d.object());
            o.mSize = d.uint32();
        }
    }
}

