/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;

public final class Primitive
extends Type {
    private String mName;
    private Method mMethod;
    private static final byte[] IDBytes = new byte[]{69, 77, -98, 125, -26, 79, 80, 116, -107, 19, 96, -67, -22, 0, 113, -109, -98, 62, -62, 78};
    public static final BinaryID ID = new BinaryID(IDBytes);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Primitive primitive = (Primitive)o;
        if (!this.mName.equals(primitive.mName)) {
            return false;
        }
        assert (this.mMethod.value == primitive.mMethod.value);
        return true;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return this.mName + "(" + this.mMethod + ")";
    }

    @Override
    public void encodeValue(Encoder e, Object value) throws IOException {
        switch (this.mMethod.value) {
            case 0: {
                e.id((BinaryID)value);
                break;
            }
            case 1: {
                e.bool((Boolean)value);
                break;
            }
            case 2: {
                e.int8((Byte)value);
                break;
            }
            case 3: {
                e.uint8((Short)value);
                break;
            }
            case 4: {
                e.int16((Short)value);
                break;
            }
            case 5: {
                e.uint16((Integer)value);
                break;
            }
            case 6: {
                e.int32((Integer)value);
                break;
            }
            case 7: {
                e.uint32((Long)value);
                break;
            }
            case 8: {
                e.int64((Long)value);
                break;
            }
            case 9: {
                e.uint64((Long)value);
                break;
            }
            case 10: {
                e.float32(((Float)value).floatValue());
                break;
            }
            case 11: {
                e.float64((Double)value);
                break;
            }
            case 12: {
                e.string((String)value);
                break;
            }
            default: {
                throw new IOException("Invalid primitive method in encode");
            }
        }
    }

    @Override
    public Object decodeValue(Decoder d) throws IOException {
        switch (this.mMethod.value) {
            case 0: {
                return d.id();
            }
            case 1: {
                return d.bool();
            }
            case 2: {
                return d.int8();
            }
            case 3: {
                return d.uint8();
            }
            case 4: {
                return d.int16();
            }
            case 5: {
                return d.uint16();
            }
            case 6: {
                return d.int32();
            }
            case 7: {
                return d.uint32();
            }
            case 8: {
                return d.int64();
            }
            case 9: {
                return d.uint64();
            }
            case 10: {
                return Float.valueOf(d.float32());
            }
            case 11: {
                return d.float64();
            }
            case 12: {
                return d.string();
            }
        }
        throw new IOException("Invalid primitive method in decode");
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public Primitive setName(String v) {
        this.mName = v;
        return this;
    }

    public Method getMethod() {
        return this.mMethod;
    }

    public Primitive setMethod(Method v) {
        this.mMethod = v;
        return this;
    }

    @Override
    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static {
        Namespace.register(ID, Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @Override
        public BinaryID id() {
            return ID;
        }

        @Override
        public BinaryObject create() {
            return new Primitive();
        }

        @Override
        public void encode(Encoder e, BinaryObject obj) throws IOException {
            Primitive o = (Primitive)obj;
            e.string(o.mName);
            o.mMethod.encode(e);
        }

        @Override
        public void decode(Decoder d, BinaryObject obj) throws IOException {
            Primitive o = (Primitive)obj;
            o.mName = d.string();
            o.mMethod = Method.decode(d);
        }
    }
}

