/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;

public final class Slice
extends Type {
    private String mAlias;
    private Type mValueType;
    private static final byte[] IDBytes = new byte[]{59, 117, -18, 89, 24, 26, 77, 116, 80, -14, 80, 127, -7, 79, 121, -103, 56, 88, -106, -46};
    public static final BinaryID ID = new BinaryID(IDBytes);

    @Override
    public String getName() {
        return "slice<" + this.mValueType.getName() + ">";
    }

    @Override
    public void encodeValue(Encoder e, Object value) throws IOException {
        assert (value instanceof Object[]);
        Object[] array = (Object[])value;
        e.uint32(array.length);
        for (Object v : array) {
            this.mValueType.encodeValue(e, v);
        }
    }

    @Override
    public Object decodeValue(Decoder d) throws IOException {
        int size = d.uint32();
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.mValueType.decodeValue(d);
        }
        return array;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public Slice setAlias(String v) {
        this.mAlias = v;
        return this;
    }

    public Type getValueType() {
        return this.mValueType;
    }

    public Slice setValueType(Type v) {
        this.mValueType = v;
        return this;
    }

    @Override
    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static {
        Namespace.register(ID, Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @Override
        public BinaryID id() {
            return ID;
        }

        @Override
        public BinaryObject create() {
            return new Slice();
        }

        @Override
        public void encode(Encoder e, BinaryObject obj) throws IOException {
            Slice o = (Slice)obj;
            e.string(o.mAlias);
            e.object(o.mValueType.unwrap());
        }

        @Override
        public void decode(Decoder d, BinaryObject obj) throws IOException {
            Slice o = (Slice)obj;
            o.mAlias = d.string();
            o.mValueType = Type.wrap(d.object());
        }
    }
}

