/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.checks.PermissionRequirement;
import java.util.Collections;
import java.util.Set;

public interface PermissionHolder {
    public boolean hasPermission(@NonNull String var1);

    public boolean isRevocable(@NonNull String var1);

    public static class SetPermissionLookup
    implements PermissionHolder {
        private Set<String> myGrantedPermissions;
        private Set<String> myRevocablePermissions;

        public SetPermissionLookup(@NonNull Set<String> grantedPermissions, @NonNull Set<String> revocablePermissions) {
            this.myGrantedPermissions = grantedPermissions;
            this.myRevocablePermissions = revocablePermissions;
        }

        public SetPermissionLookup(@NonNull Set<String> grantedPermissions) {
            this(grantedPermissions, Collections.emptySet());
        }

        @Override
        public boolean hasPermission(@NonNull String permission) {
            return this.myGrantedPermissions.contains(permission);
        }

        @Override
        public boolean isRevocable(@NonNull String permission) {
            return this.myRevocablePermissions.contains(permission);
        }

        @NonNull
        public static PermissionHolder join(@NonNull PermissionHolder lookup, @NonNull PermissionRequirement requirement) {
            SetPermissionLookup empty = new SetPermissionLookup(Collections.<String>emptySet());
            return SetPermissionLookup.join(lookup, requirement.getMissingPermissions(empty));
        }

        @NonNull
        public static PermissionHolder join(final @NonNull PermissionHolder lookup, final @Nullable Set<String> permissions) {
            if (permissions != null && !permissions.isEmpty()) {
                return new PermissionHolder(){

                    @Override
                    public boolean hasPermission(@NonNull String permission) {
                        return lookup.hasPermission(permission) || permissions.contains(permission);
                    }

                    @Override
                    public boolean isRevocable(@NonNull String permission) {
                        return lookup.isRevocable(permission);
                    }
                };
            }
            return lookup;
        }
    }
}

