/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.ModuleDeploymentSource;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.remoteServer.util.CloudGitDeploymentRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import java.io.File;
import java.util.List;

public class CloudGitDeploymentChecker<T extends CloudDeploymentNameConfiguration, SC extends ServerConfigurationBase, SR extends CloudMultiSourceServerRuntimeInstance<T, ?, ?, ?>> {
    private final CloudGitDeploymentDetector myDetector;

    public CloudGitDeploymentChecker(CloudGitDeploymentDetector detector) {
        this.myDetector = detector;
    }

    public void checkGitUrl(RemoteServer<SC> server, DeploymentSource deploymentSource, T settings) throws RuntimeConfigurationException {
        if (!(deploymentSource instanceof ModuleDeploymentSource)) {
            return;
        }
        ModuleDeploymentSource moduleSource = (ModuleDeploymentSource)deploymentSource;
        Module module = moduleSource.getModule();
        if (module == null) {
            return;
        }
        File contentRootFile = deploymentSource.getFile();
        if (contentRootFile == null) {
            return;
        }
        final Project project = module.getProject();
        VirtualFile contentRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(contentRootFile);
        if (contentRoot == null) {
            return;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(contentRoot);
        if (repository == null) {
            return;
        }
        String expectedName = settings.getDeploymentSourceName(deploymentSource);
        List<String> appNames = this.myDetector.collectApplicationNames(repository);
        if (appNames.isEmpty() || appNames.contains(expectedName)) {
            return;
        }
        RuntimeConfigurationWarning warning = new RuntimeConfigurationWarning("Cloud Git URL found in repository, but it doesn't match the run configuration");
        warning.setQuickFix(new Runnable((RemoteServer)server, deploymentSource, (CloudDeploymentNameConfiguration)settings){
            final /* synthetic */ RemoteServer val$server;
            final /* synthetic */ DeploymentSource val$deploymentSource;
            final /* synthetic */ CloudDeploymentNameConfiguration val$settings;
            {
                this.val$server = remoteServer;
                this.val$deploymentSource = deploymentSource;
                this.val$settings = cloudDeploymentNameConfiguration;
            }

            @Override
            public void run() {
                CloudGitApplication application = (CloudGitApplication)new CloudConnectionTask<CloudGitApplication, SC, T, SR>(project, "Searching for application", this.val$server){

                    protected CloudGitApplication run(SR serverRuntime) throws ServerRuntimeException {
                        CloudGitDeploymentRuntime deploymentRuntime = (CloudGitDeploymentRuntime)serverRuntime.createDeploymentRuntime(val$deploymentSource, val$settings, project);
                        return deploymentRuntime.findApplication4Repository();
                    }
                }.performSync();
                if (application == null) {
                    Messages.showErrorDialog((Project)project, (String)"No application matching repository URL(s) found in account", (String)this.val$server.getName());
                } else {
                    this.val$settings.setDefaultDeploymentName(false);
                    this.val$settings.setDeploymentName(application.getName());
                }
            }
        });
        throw warning;
    }
}

