/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitExecutorBase;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.Semaphore;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitProgressAnalyzer;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitTask;
import git4idea.commands.GitTaskResult;
import git4idea.commands.GitTaskResultHandler;
import git4idea.commands.GitTaskResultHandlerAdapter;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;

public class CloudGitDeploymentRuntime
extends CloudDeploymentRuntime {
    private static final Logger LOG = Logger.getInstance((String)("#" + CloudGitDeploymentRuntime.class.getName()));
    private static final String COMMIT_MESSAGE = "Deploy";
    private static final CommitSession NO_COMMIT = new CommitSession(){

        public JComponent getAdditionalConfigurationUI() {
            return null;
        }

        public JComponent getAdditionalConfigurationUI(Collection<Change> changes, String commitMessage) {
            return null;
        }

        public boolean canExecute(Collection<Change> changes, String commitMessage) {
            return true;
        }

        public void execute(Collection<Change> changes, String commitMessage) {
        }

        public void executionCanceled() {
        }

        public String getHelpId() {
            return null;
        }
    };
    private static final List<CommitExecutor> ourCommitExecutors = Arrays.asList(new CommitExecutor(){

        public String getActionText() {
            return "Commit and Push";
        }

        public CommitSession createCommitSession() {
            return CommitSession.VCS_COMMIT;
        }
    }, new CommitExecutorBase(){

        public String getActionText() {
            return "Push without Commit";
        }

        public CommitSession createCommitSession() {
            return NO_COMMIT;
        }

        public boolean areChangesRequired() {
            return false;
        }
    });
    private final GitRepositoryManager myGitRepositoryManager;
    private final Git myGit;
    private final VirtualFile myContentRoot;
    private final File myRepositoryRootFile;
    private final String myDefaultRemoteName;
    private final ChangeListManagerEx myChangeListManager;
    private String myRemoteName;
    private final String myCloudName;
    private GitRepository myRepository;

    public CloudGitDeploymentRuntime(CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentSource source, File repositoryRoot, DeploymentTask<? extends CloudDeploymentNameConfiguration> task, DeploymentLogManager logManager, String defaultRemoteName, String cloudName) throws ServerRuntimeException {
        super(serverRuntime, source, task, logManager);
        this.myDefaultRemoteName = defaultRemoteName;
        this.myCloudName = cloudName;
        this.myRepositoryRootFile = repositoryRoot;
        VirtualFile contentRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myRepositoryRootFile);
        LOG.assertTrue(contentRoot != null, (Object)"Repository root is not found");
        this.myContentRoot = contentRoot;
        Project project = this.getProject();
        this.myGitRepositoryManager = GitUtil.getRepositoryManager((Project)project);
        this.myGit = (Git)ServiceManager.getService(Git.class);
        if (this.myGit == null) {
            throw new ServerRuntimeException("Can't initialize GIT");
        }
        GitPlatformFacade gitPlatformFacade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        this.myChangeListManager = gitPlatformFacade.getChangeListManager(project);
    }

    public CloudGitApplication deploy() throws ServerRuntimeException {
        CloudGitApplication application = this.findOrCreateApplication();
        this.deployApplication(application);
        return application;
    }

    private void deployApplication(CloudGitApplication application) throws ServerRuntimeException {
        boolean firstDeploy = this.findRepository() == null;
        GitRepository repository = this.findOrCreateRepository();
        this.addOrResetGitRemote(application, repository);
        if (firstDeploy) {
            this.add();
            this.commit();
            return;
        }
        final LocalChangeList activeChangeList = this.myChangeListManager.getDefaultChangeList();
        if (activeChangeList == null) {
            this.add();
            this.commit();
            return;
        }
        Collection changes = activeChangeList.getChanges();
        final ArrayList<Change> relevantChanges = new ArrayList<Change>();
        for (Change change : changes) {
            if (!this.isRelevant(change.getBeforeRevision()) && !this.isRelevant(change.getAfterRevision())) continue;
            relevantChanges.add(change);
        }
        final Semaphore commitSemaphore = new Semaphore();
        commitSemaphore.down();
        final Ref commitSucceeded = new Ref((Object)false);
        Boolean commitStarted = CloudGitDeploymentRuntime.runOnEdt(new Computable<Boolean>(){

            public Boolean compute() {
                return CommitChangeListDialog.commitChanges((Project)CloudGitDeploymentRuntime.this.getProject(), (List)relevantChanges, (LocalChangeList)activeChangeList, (List)ourCommitExecutors, (boolean)false, (String)CloudGitDeploymentRuntime.COMMIT_MESSAGE, (CommitResultHandler)new CommitResultHandler(){

                    public void onSuccess(String commitMessage) {
                        commitSucceeded.set((Object)true);
                        commitSemaphore.up();
                    }

                    public void onFailure() {
                        commitSemaphore.up();
                    }
                }, (boolean)false);
            }
        });
        if (commitStarted != null && commitStarted.booleanValue()) {
            commitSemaphore.waitFor();
            if (!((Boolean)commitSucceeded.get()).booleanValue()) {
                repository.update();
                throw new ServerRuntimeException("Commit failed");
            }
        } else {
            throw new ServerRuntimeException("Deploy interrupted");
        }
        repository.update();
        this.pushApplication(application);
    }

    private boolean isRelevant(ContentRevision contentRevision) throws ServerRuntimeException {
        if (contentRevision == null) {
            return false;
        }
        GitRepository repository = this.getRepository();
        VirtualFile affectedFile = contentRevision.getFile().getVirtualFile();
        return affectedFile != null && VfsUtilCore.isAncestor((VirtualFile)repository.getRoot(), (VirtualFile)affectedFile, (boolean)false);
    }

    private static <T> T runOnEdt(final Computable<T> computable) {
        final Ref result = new Ref();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                result.set(computable.compute());
            }
        }, ModalityState.any());
        return (T)result.get();
    }

    public boolean isDeployed() throws ServerRuntimeException {
        return this.findApplication() != null;
    }

    public CloudGitApplication findOrCreateApplication() throws ServerRuntimeException {
        CloudGitApplication application = this.findApplication();
        if (application == null) {
            application = this.createApplication();
        }
        return application;
    }

    public void addOrResetGitRemote(CloudGitApplication application, GitRepository repository) throws ServerRuntimeException {
        GitRemote gitRemote;
        String gitUrl = application.getGitUrl();
        if (this.myRemoteName == null) {
            for (GitRemote gitRemote2 : repository.getRemotes()) {
                if (!gitRemote2.getUrls().contains(gitUrl)) continue;
                this.myRemoteName = gitRemote2.getName();
                return;
            }
        }
        if ((gitRemote = GitUtil.findRemoteByName((GitRepository)repository, (String)this.getRemoteName())) == null) {
            this.addGitRemote(application);
        } else if (!gitRemote.getUrls().contains(gitUrl)) {
            this.resetGitRemote(application);
        }
    }

    public GitRepository findOrCreateRepository() throws ServerRuntimeException {
        GitRepository repository = this.findRepository();
        if (repository == null) {
            this.getLoggingHandler().println("Initializing git repository...");
            GitCommandResult gitInitResult = this.getGit().init(this.getProject(), this.getRepositoryRoot(), new GitLineHandlerListener[]{this.createGitLineHandlerListener()});
            CloudGitDeploymentRuntime.checkGitResult(gitInitResult);
            this.refreshApplicationRepository();
            repository = this.getRepository();
        }
        return repository;
    }

    public void downloadExistingApplication() throws ServerRuntimeException {
        new CloneJobWithRemote().cloneToModule(this.getApplication().getGitUrl());
        this.getRepository().update();
        this.refreshContentRoot();
    }

    protected Git getGit() {
        return this.myGit;
    }

    protected VirtualFile getRepositoryRoot() {
        return this.myContentRoot;
    }

    protected File getRepositoryRootFile() {
        return this.myRepositoryRootFile;
    }

    protected static void checkGitResult(GitCommandResult commandResult) throws ServerRuntimeException {
        if (!commandResult.success()) {
            Throwable exception = commandResult.getException();
            if (exception != null) {
                LOG.info(exception);
                throw new ServerRuntimeException(exception);
            }
            throw new ServerRuntimeException(commandResult.getErrorOutputAsJoinedString());
        }
    }

    protected GitLineHandlerListener createGitLineHandlerListener() {
        return new GitLineHandlerAdapter(){

            public void onLineAvailable(String line, Key outputType) {
                CloudGitDeploymentRuntime.this.getLoggingHandler().println(line);
            }
        };
    }

    protected CloudAgentLoggingHandler getLoggingHandler() {
        return super.getLoggingHandler();
    }

    protected void addGitRemote(CloudGitApplication application) throws ServerRuntimeException {
        this.doGitRemote(this.getRemoteName(), application, "add", CloudBundle.getText((String)"failed.add.remote", (Object[])new Object[]{this.getRemoteName()}));
    }

    protected void resetGitRemote(CloudGitApplication application) throws ServerRuntimeException {
        this.doGitRemote(this.getRemoteName(), application, "set-url", CloudBundle.getText((String)"failed.reset.remote", (Object[])new Object[]{this.getRemoteName()}));
    }

    protected void doGitRemote(String remoteName, CloudGitApplication application, String subCommand, String failMessage) throws ServerRuntimeException {
        try {
            GitSimpleHandler handler = new GitSimpleHandler(this.getProject(), this.myContentRoot, GitCommand.REMOTE);
            handler.setSilent(false);
            handler.addParameters(new String[]{subCommand, remoteName, application.getGitUrl()});
            handler.run();
            this.getRepository().update();
            if (handler.getExitCode() != 0) {
                throw new ServerRuntimeException(failMessage);
            }
        }
        catch (VcsException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
    }

    protected GitRepository findRepository() {
        if (this.myRepository != null) {
            return this.myRepository;
        }
        this.myRepository = (GitRepository)this.myGitRepositoryManager.getRepositoryForRoot(this.myContentRoot);
        return this.myRepository;
    }

    protected void refreshApplicationRepository() {
        GitInit.refreshAndConfigureVcsMappings((Project)this.getProject(), (VirtualFile)this.getRepositoryRoot(), (String)this.getRepositoryRootFile().getAbsolutePath());
    }

    protected void pushApplication(CloudGitApplication application) throws ServerRuntimeException {
        this.push(application, this.getRepository(), this.getRemoteName());
    }

    protected void push(CloudGitApplication application, GitRepository repository, String remote) throws ServerRuntimeException {
        GitCommandResult gitPushResult = this.getGit().push(repository, remote, application.getGitUrl(), "master:master", new GitLineHandlerListener[]{this.createGitLineHandlerListener()});
        CloudGitDeploymentRuntime.checkGitResult(gitPushResult);
    }

    protected GitRepository getRepository() throws ServerRuntimeException {
        GitRepository repository = this.findRepository();
        if (repository == null) {
            throw new ServerRuntimeException("Unable to find GIT repository for module root: " + this.myContentRoot);
        }
        return repository;
    }

    protected void fetch() throws ServerRuntimeException {
        VirtualFile contentRoot = this.getRepositoryRoot();
        GitRepository repository = this.getRepository();
        GitLineHandler fetchHandler = new GitLineHandler(this.getProject(), contentRoot, GitCommand.FETCH);
        fetchHandler.setUrl(this.getApplication().getGitUrl());
        fetchHandler.setSilent(false);
        fetchHandler.addParameters(new String[]{this.getRemoteName()});
        fetchHandler.addLineListener(this.createGitLineHandlerListener());
        this.performRemoteGitTask(fetchHandler, CloudBundle.getText((String)"fetching.application", (Object[])new Object[]{this.getCloudName()}));
        repository.update();
    }

    protected void add() throws ServerRuntimeException {
        try {
            GitFileUtils.addFiles((Project)this.getProject(), (VirtualFile)this.myContentRoot, (VirtualFile[])new VirtualFile[]{this.myContentRoot});
        }
        catch (VcsException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
    }

    protected void commit() throws ServerRuntimeException {
        try {
            if (GitUtil.hasLocalChanges((boolean)true, (Project)this.getProject(), (VirtualFile)this.myContentRoot)) {
                GitSimpleHandler handler = new GitSimpleHandler(this.getProject(), this.myContentRoot, GitCommand.COMMIT);
                handler.setSilent(false);
                handler.setStdoutSuppressed(false);
                handler.addParameters(new String[]{"-m", COMMIT_MESSAGE});
                handler.endOptions();
                handler.run();
            }
        }
        catch (VcsException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
    }

    protected void performRemoteGitTask(final GitLineHandler handler, String title) throws ServerRuntimeException {
        final GitTask task = new GitTask(this.getProject(), (GitHandler)handler, title);
        task.setProgressAnalyzer((GitProgressAnalyzer)new GitStandardProgressAnalyzer());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref errorRef = new Ref();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                task.execute(false, false, (GitTaskResultHandler)new GitTaskResultHandlerAdapter(){

                    protected void run(GitTaskResult result) {
                        super.run(result);
                        semaphore.up();
                    }

                    protected void onFailure() {
                        for (VcsException error : handler.errors()) {
                            CloudGitDeploymentRuntime.this.getLoggingHandler().println(error.toString());
                            if (!errorRef.isNull()) continue;
                            errorRef.set((Object)new ServerRuntimeException((Throwable)error));
                        }
                    }
                });
            }
        });
        semaphore.waitFor();
        if (!errorRef.isNull()) {
            throw (ServerRuntimeException)errorRef.get();
        }
    }

    protected void refreshContentRoot() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                CloudGitDeploymentRuntime.this.getRepositoryRoot().refresh(false, true);
            }
        });
    }

    public void fetchAndRefresh() throws ServerRuntimeException {
        this.fetch();
        this.refreshContentRoot();
    }

    private String getRemoteName() {
        if (this.myRemoteName == null) {
            this.myRemoteName = this.myDefaultRemoteName;
        }
        return this.myRemoteName;
    }

    private String getCloudName() {
        return this.myCloudName;
    }

    protected CloudGitApplication findApplication() throws ServerRuntimeException {
        return (CloudGitApplication)this.getAgentTaskExecutor().execute((Computable)new Computable<CloudGitApplication>(){

            public CloudGitApplication compute() {
                return CloudGitDeploymentRuntime.this.getDeployment().findApplication();
            }
        });
    }

    protected CloudGitApplication getApplication() throws ServerRuntimeException {
        CloudGitApplication application = this.findApplication();
        if (application == null) {
            throw new ServerRuntimeException("Can't find the application: " + this.getApplicationName());
        }
        return application;
    }

    protected CloudGitApplication createApplication() throws ServerRuntimeException {
        return (CloudGitApplication)this.getAgentTaskExecutor().execute((Computable)new Computable<CloudGitApplication>(){

            public CloudGitApplication compute() {
                return CloudGitDeploymentRuntime.this.getDeployment().createApplication();
            }
        });
    }

    public CloudGitApplication findApplication4Repository() throws ServerRuntimeException {
        final ArrayList<String> repositoryUrls = new ArrayList<String>();
        for (GitRemote remote : this.getRepository().getRemotes()) {
            for (String url : remote.getUrls()) {
                repositoryUrls.add(url);
            }
        }
        return (CloudGitApplication)this.getAgentTaskExecutor().execute((Computable)new Computable<CloudGitApplication>(){

            public CloudGitApplication compute() {
                return CloudGitDeploymentRuntime.this.getDeployment().findApplication4Repository(ArrayUtil.toStringArray((Collection)repositoryUrls));
            }
        });
    }

    public class CloneJobWithRemote
    extends CloneJob {
        @Override
        public void doClone(File cloneDirParent, String cloneDirName, String gitUrl) throws ServerRuntimeException {
            GitLineHandler handler = new GitLineHandler(CloudGitDeploymentRuntime.this.getProject(), cloneDirParent, GitCommand.CLONE);
            handler.setSilent(false);
            handler.setStdoutSuppressed(false);
            handler.setUrl(gitUrl);
            handler.addParameters(new String[]{"--progress"});
            handler.addParameters(new String[]{gitUrl});
            handler.addParameters(new String[]{cloneDirName});
            handler.addParameters(new String[]{"-o"});
            handler.addParameters(new String[]{CloudGitDeploymentRuntime.this.getRemoteName()});
            handler.addLineListener(CloudGitDeploymentRuntime.this.createGitLineHandlerListener());
            CloudGitDeploymentRuntime.this.performRemoteGitTask(handler, CloudBundle.getText((String)"cloning.existing.application", (Object[])new Object[]{CloudGitDeploymentRuntime.this.getCloudName()}));
        }
    }

    public class CloneJob {
        public File cloneToTemp(String gitUrl) throws ServerRuntimeException {
            File cloneDir;
            try {
                cloneDir = FileUtil.createTempDirectory((String)"cloud", (String)"clone");
            }
            catch (IOException e) {
                throw new ServerRuntimeException((Throwable)e);
            }
            File cloneDirParent = cloneDir.getParentFile();
            String cloneDirName = cloneDir.getName();
            this.doClone(cloneDirParent, cloneDirName, gitUrl);
            return cloneDir;
        }

        public void cloneToModule(String gitUrl) throws ServerRuntimeException {
            File cloneDir = this.cloneToTemp(gitUrl);
            try {
                FileUtil.copyDir((File)cloneDir, (File)CloudGitDeploymentRuntime.this.getRepositoryRootFile());
            }
            catch (IOException e) {
                throw new ServerRuntimeException((Throwable)e);
            }
            CloudGitDeploymentRuntime.this.refreshApplicationRepository();
        }

        public void doClone(File cloneDirParent, String cloneDirName, String gitUrl) throws ServerRuntimeException {
            GitCommandResult gitCloneResult = CloudGitDeploymentRuntime.this.getGit().clone(CloudGitDeploymentRuntime.this.getProject(), cloneDirParent, gitUrl, cloneDirName, new GitLineHandlerListener[]{CloudGitDeploymentRuntime.this.createGitLineHandlerListener()});
            CloudGitDeploymentRuntime.checkGitResult(gitCloneResult);
        }
    }
}

