/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import java.io.File;

public class CloudGitProjectRoot
extends DetectedProjectRoot {
    private final String myRootTypeName;
    private final String myJavaSourceRootTypeName;
    private final VirtualFile myRepositoryRoot;
    private final String myApplicationName;

    public static String getProjectRootTypeName(CloudGitDeploymentDetector detector) {
        return detector.getCloudType().getPresentableName();
    }

    public static String getJavaSourceRootTypeName(CloudGitDeploymentDetector detector) {
        return "Java/" + CloudGitProjectRoot.getProjectRootTypeName(detector);
    }

    public CloudGitProjectRoot(CloudGitDeploymentDetector detector, File directory, VirtualFile repositoryRoot, String applicationName) {
        super(directory);
        this.myRootTypeName = CloudGitProjectRoot.getProjectRootTypeName(detector);
        this.myJavaSourceRootTypeName = CloudGitProjectRoot.getJavaSourceRootTypeName(detector);
        this.myRepositoryRoot = repositoryRoot;
        this.myApplicationName = applicationName;
    }

    public String getRootTypeName() {
        return this.myRootTypeName;
    }

    public boolean canContainRoot(DetectedProjectRoot root) {
        return this.myJavaSourceRootTypeName.equals(root.getRootTypeName());
    }

    public String getApplicationName() {
        return this.myApplicationName;
    }

    public VirtualFile getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public String getJavaSourceRootTypeName() {
        return this.myJavaSourceRootTypeName;
    }
}

