/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.androidTarget;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.utils.SparseArray;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class PlatformTarget
implements IAndroidTarget {
    private static final String PLATFORM_VENDOR = "Android Open Source Project";
    private static final String PLATFORM_NAME = "Android %s";
    private static final String PLATFORM_NAME_PREVIEW = "Android %s (Preview)";
    private final String mRootFolderOsPath;
    private final String mName;
    private final AndroidVersion mVersion;
    private final String mVersionName;
    private final int mRevision;
    private final Map<String, String> mProperties;
    private final SparseArray<String> mPaths = new SparseArray();
    private File[] mSkins;
    private final ISystemImage[] mSystemImages;
    private final List<IAndroidTarget.OptionalLibrary> mOptionalLibraries;
    private final SdkManager.LayoutlibVersion mLayoutlibVersion;
    private final BuildToolInfo mBuildToolInfo;

    public PlatformTarget(String sdkOsPath, String platformOSPath, AndroidVersion apiVersion, String versionName, int revision, SdkManager.LayoutlibVersion layoutlibVersion, ISystemImage[] systemImages, Map<String, String> properties, List<IAndroidTarget.OptionalLibrary> optionalLibraries, @NonNull BuildToolInfo buildToolInfo) {
        if (!platformOSPath.endsWith(File.separator)) {
            platformOSPath = platformOSPath + File.separator;
        }
        this.mRootFolderOsPath = platformOSPath;
        this.mProperties = Collections.unmodifiableMap(properties);
        this.mVersion = apiVersion;
        this.mVersionName = versionName;
        this.mRevision = revision;
        this.mLayoutlibVersion = layoutlibVersion;
        this.mBuildToolInfo = buildToolInfo;
        this.mSystemImages = systemImages == null ? new ISystemImage[]{} : systemImages;
        Arrays.sort(this.mSystemImages);
        this.mOptionalLibraries = ImmutableList.copyOf(optionalLibraries);
        this.mName = this.mVersion.isPreview() ? String.format(PLATFORM_NAME_PREVIEW, this.mVersionName) : String.format(PLATFORM_NAME, this.mVersionName);
        this.mPaths.put(1, (Object)(this.mRootFolderOsPath + "android.jar"));
        this.mPaths.put(27, (Object)(this.mRootFolderOsPath + "uiautomator.jar"));
        this.mPaths.put(18, (Object)(this.mRootFolderOsPath + "sources"));
        this.mPaths.put(2, (Object)(this.mRootFolderOsPath + "framework.aidl"));
        this.mPaths.put(4, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_SAMPLES_FOLDER));
        this.mPaths.put(5, (Object)(this.mRootFolderOsPath + SdkConstants.OS_SKINS_FOLDER));
        this.mPaths.put(6, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_TEMPLATES_FOLDER));
        this.mPaths.put(7, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER));
        this.mPaths.put(8, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_ATTRS_XML));
        this.mPaths.put(9, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_ATTRS_MANIFEST_XML));
        this.mPaths.put(11, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_RESOURCES_FOLDER));
        this.mPaths.put(12, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_FONTS_FOLDER));
        this.mPaths.put(10, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "layoutlib.jar"));
        this.mPaths.put(13, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "widgets.txt"));
        this.mPaths.put(14, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "activity_actions.txt"));
        this.mPaths.put(15, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "broadcast_actions.txt"));
        this.mPaths.put(16, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "service_actions.txt"));
        this.mPaths.put(17, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "categories.txt"));
        this.mPaths.put(24, (Object)(this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_ANT_FOLDER));
    }

    public SdkManager.LayoutlibVersion getLayoutlibVersion() {
        return this.mLayoutlibVersion;
    }

    @Override
    @Nullable
    public ISystemImage getSystemImage(@NonNull IdDisplay tag, @NonNull String abiType) {
        for (ISystemImage sysImg : this.mSystemImages) {
            if (!sysImg.getTag().equals(tag) || !sysImg.getAbiType().equals(abiType)) continue;
            return sysImg;
        }
        return null;
    }

    @Override
    public ISystemImage[] getSystemImages() {
        return this.mSystemImages;
    }

    @Override
    public String getLocation() {
        return this.mRootFolderOsPath;
    }

    @Override
    public String getVendor() {
        return PLATFORM_VENDOR;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getFullName() {
        return this.mName;
    }

    @Override
    public String getClasspathName() {
        return this.mName;
    }

    @Override
    public String getShortClasspathName() {
        return this.mName;
    }

    @Override
    public String getDescription() {
        return String.format("Standard Android platform %s", this.mVersionName);
    }

    @Override
    @NonNull
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    @Override
    public String getVersionName() {
        return this.mVersionName;
    }

    @Override
    public int getRevision() {
        return this.mRevision;
    }

    @Override
    public boolean isPlatform() {
        return true;
    }

    @Override
    public IAndroidTarget getParent() {
        return null;
    }

    @Override
    public String getPath(int pathId) {
        return (String)this.mPaths.get(pathId);
    }

    @Override
    public File getFile(int pathId) {
        return new File(this.getPath(pathId));
    }

    @Override
    public BuildToolInfo getBuildToolInfo() {
        return this.mBuildToolInfo;
    }

    @Override
    @NonNull
    public List<String> getBootClasspath() {
        return ImmutableList.of((Object)this.getPath(1));
    }

    @Override
    @NonNull
    public List<IAndroidTarget.OptionalLibrary> getOptionalLibraries() {
        return this.mOptionalLibraries;
    }

    @Override
    @NonNull
    public List<IAndroidTarget.OptionalLibrary> getAdditionalLibraries() {
        return ImmutableList.of();
    }

    @Override
    public boolean hasRenderingLibrary() {
        return true;
    }

    @Override
    @NonNull
    public File[] getSkins() {
        return this.mSkins;
    }

    @Override
    @Nullable
    public File getDefaultSkin() {
        if (this.mSkins.length == 1) {
            return this.mSkins[0];
        }
        String skinName = this.mProperties.get("sdk.skin.default");
        if (skinName == null) {
            skinName = this.mVersion.getApiLevel() >= 4 ? "WVGA800" : "HVGA";
        }
        return new File(this.getFile(5), skinName);
    }

    @Override
    public String[] getPlatformLibraries() {
        return new String[]{"android.test.runner"};
    }

    @Override
    public int getUsbVendorId() {
        return 0;
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        if (target == this) {
            return true;
        }
        if (this.mVersion.getCodename() != null) {
            return this.mVersion.equals(target.getVersion());
        }
        return target.getVersion().getApiLevel() >= this.mVersion.getApiLevel();
    }

    @Override
    public String hashString() {
        return AndroidTargetHash.getPlatformHashString(this.mVersion);
    }

    public int hashCode() {
        return this.hashString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlatformTarget) {
            PlatformTarget platform = (PlatformTarget)obj;
            return this.mVersion.equals(platform.getVersion());
        }
        return false;
    }

    @Override
    public int compareTo(IAndroidTarget target) {
        if (this == target) {
            return 0;
        }
        int versionDiff = this.mVersion.compareTo(target.getVersion());
        if (versionDiff == 0 && !target.isPlatform()) {
            return -1;
        }
        return versionDiff;
    }

    public String toString() {
        return String.format("PlatformTarget %1$s rev %2$d", this.getVersion(), this.getRevision());
    }

    @Override
    public String getProperty(String name) {
        return this.mProperties.get(name);
    }

    @Override
    public Integer getProperty(String name, Integer defaultValue) {
        try {
            String value = this.getProperty(name);
            if (value != null) {
                return Integer.decode(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public Boolean getProperty(String name, Boolean defaultValue) {
        String value = this.getProperty(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    public void setSkins(@NonNull File[] skins) {
        this.mSkins = skins;
        Arrays.sort(this.mSkins);
    }

    public void setSamplesPath(String osLocation) {
        this.mPaths.put(4, (Object)osLocation);
    }

    public void setSourcesPath(String osLocation) {
        this.mPaths.put(18, (Object)osLocation);
    }
}

