/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.descriptors;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.License;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDescExtra;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;

public final class PkgDescExtra
extends PkgDesc
implements IPkgDescExtra {
    private final String[] mOldPaths;
    private final String mNameDisplay;

    PkgDescExtra(@NonNull PkgType type, @Nullable License license, @Nullable String listDisplay, @Nullable String descriptionShort, @Nullable String descriptionUrl, boolean isObsolete, @Nullable FullRevision fullRevision, @Nullable MajorRevision majorRevision, @Nullable AndroidVersion androidVersion, @Nullable String path, @Nullable IdDisplay tag, @Nullable IdDisplay vendor, @Nullable FullRevision minToolsRev, @Nullable FullRevision minPlatformToolsRev, @Nullable String nameDisplay, @Nullable String[] oldPaths) {
        super(type, license, listDisplay, descriptionShort, descriptionUrl, isObsolete, fullRevision, majorRevision, androidVersion, path, tag, vendor, minToolsRev, minPlatformToolsRev, null, null);
        this.mNameDisplay = nameDisplay;
        this.mOldPaths = oldPaths != null ? oldPaths : new String[]{};
    }

    @Override
    @NonNull
    public String[] getOldPaths() {
        return this.mOldPaths;
    }

    @Override
    @NonNull
    public String getNameDisplay() {
        return this.mNameDisplay == null ? String.format("Unknown (%s)", this.getInstallId()) : this.mNameDisplay;
    }

    @NonNull
    public static String[] convertOldPaths(@Nullable String oldPathsProperty) {
        if (oldPathsProperty == null || oldPathsProperty.length() == 0) {
            return new String[0];
        }
        return oldPathsProperty.split(";");
    }

    public static boolean compatibleVendorAndPath(@NonNull IPkgDescExtra lhs, @NonNull IPkgDescExtra rhs) {
        String[] epOldPaths = rhs.getOldPaths();
        int lenEpOldPaths = epOldPaths.length;
        for (int indexEp = -1; indexEp < lenEpOldPaths; ++indexEp) {
            if (!PkgDescExtra.sameVendorAndPath(lhs.getVendor().getId(), lhs.getPath(), rhs.getVendor().getId(), indexEp < 0 ? rhs.getPath() : epOldPaths[indexEp])) continue;
            return true;
        }
        String[] thisOldPaths = lhs.getOldPaths();
        int lenThisOldPaths = thisOldPaths.length;
        for (int indexThis = -1; indexThis < lenThisOldPaths; ++indexThis) {
            if (!PkgDescExtra.sameVendorAndPath(lhs.getVendor().getId(), indexThis < 0 ? lhs.getPath() : thisOldPaths[indexThis], rhs.getVendor().getId(), rhs.getPath())) continue;
            return true;
        }
        return false;
    }

    private static boolean sameVendorAndPath(@Nullable String thisVendor, @Nullable String thisPath, @Nullable String otherVendor, @Nullable String otherPath) {
        if (otherPath != null && thisPath != null && thisVendor != null && otherPath.equals(thisVendor + '-' + thisPath) && (otherVendor == null || otherVendor.length() == 0 || otherVendor.equals(thisVendor))) {
            return true;
        }
        if (thisPath != null && otherPath != null && otherVendor != null && thisPath.equals(otherVendor + '-' + otherPath) && (thisVendor == null || thisVendor.length() == 0 || thisVendor.equals(otherVendor))) {
            return true;
        }
        return thisPath != null && thisPath.equals(otherPath) && (thisVendor == null && otherVendor == null || thisVendor != null && thisVendor.equals(otherVendor));
    }
}

