/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.SystemImage;
import com.android.sdklib.internal.androidTarget.OptionalLibraryImpl;
import com.android.sdklib.internal.androidTarget.PlatformTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.sdklib.repository.local.LocalSysImgPkgInfo;
import com.android.sdklib.repository.local.PackageParserUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class LocalPlatformPkgInfo
extends LocalPkgInfo {
    public static final String PROP_VERSION_SDK = "ro.build.version.sdk";
    public static final String PROP_VERSION_CODENAME = "ro.build.version.codename";
    public static final String PROP_VERSION_RELEASE = "ro.build.version.release";
    @NonNull
    private final IPkgDesc mDesc;
    private IAndroidTarget mTarget;
    private boolean mLoaded;
    private static final String[] sPlatformContentList = new String[]{"android.jar", "framework.aidl"};

    public LocalPlatformPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps, @NonNull AndroidVersion version, @NonNull MajorRevision revision, @NonNull FullRevision minToolsRev) {
        super(localSdk, localDir, sourceProps);
        this.mDesc = PkgDesc.Builder.newPlatform(version, revision, minToolsRev).create();
    }

    @Override
    @NonNull
    public IPkgDesc getDesc() {
        return this.mDesc;
    }

    @NonNull
    public String getTargetHash() {
        return this.getDesc().getPath();
    }

    @Nullable
    public IAndroidTarget getAndroidTarget() {
        if (!this.mLoaded) {
            this.mTarget = this.createAndroidTarget();
            this.mLoaded = true;
        }
        return this.mTarget;
    }

    public boolean isLoaded() {
        return this.mLoaded;
    }

    @Nullable
    protected IAndroidTarget createAndroidTarget() {
        LocalPkgInfo sources;
        int apiNumber;
        String stringValue;
        LocalSdk sdk = this.getLocalSdk();
        IFileOp fileOp = sdk.getFileOp();
        File platformFolder = this.getLocalDir();
        File buildProp = new File(platformFolder, "build.prop");
        File sourcePropFile = new File(platformFolder, "source.properties");
        if (!fileOp.isFile(buildProp) || !fileOp.isFile(sourcePropFile)) {
            this.appendLoadError("Ignoring platform '%1$s': %2$s is missing.", platformFolder.getName(), "build.prop");
            return null;
        }
        HashMap<String, String> platformProp = new HashMap<String, String>();
        Map<String, String> map = null;
        try {
            map = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(buildProp), buildProp.getPath(), null);
            if (map != null) {
                platformProp.putAll(map);
            }
        }
        catch (FileNotFoundException ignore) {
            // empty catch block
        }
        try {
            map = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(sourcePropFile), sourcePropFile.getPath(), null);
            if (map != null) {
                platformProp.putAll(map);
            }
        }
        catch (FileNotFoundException ignore) {
            // empty catch block
        }
        File sdkPropFile = new File(platformFolder, "sdk.properties");
        if (fileOp.isFile(sdkPropFile)) {
            try {
                map = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(sdkPropFile), sdkPropFile.getPath(), null);
                if (map != null) {
                    platformProp.putAll(map);
                }
            }
            catch (FileNotFoundException ignore) {
                // empty catch block
            }
        }
        if ((stringValue = (String)platformProp.get(PROP_VERSION_SDK)) == null) {
            this.appendLoadError("Ignoring platform '%1$s': %2$s is missing from '%3$s'", platformFolder.getName(), PROP_VERSION_SDK, "build.prop");
            return null;
        }
        try {
            apiNumber = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            this.appendLoadError("Ignoring platform '%1$s': %2$s is not a valid number in %3$s.", platformFolder.getName(), PROP_VERSION_SDK, "build.prop");
            return null;
        }
        AndroidVersion apiVersion = new AndroidVersion(apiNumber, (String)platformProp.get(PROP_VERSION_CODENAME));
        String apiName = (String)platformProp.get("Platform.Version");
        if (apiName == null) {
            apiName = (String)platformProp.get(PROP_VERSION_RELEASE);
        }
        if (apiName == null) {
            this.appendLoadError("Ignoring platform '%1$s': %2$s is missing from '%3$s'", platformFolder.getName(), PROP_VERSION_RELEASE, "build.prop");
            return null;
        }
        int revision = 1;
        SdkManager.LayoutlibVersion layoutlibVersion = null;
        try {
            revision = Integer.parseInt((String)platformProp.get("Pkg.Revision"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            int llRev;
            String propApi = (String)platformProp.get("Layoutlib.Api");
            String propRev = (String)platformProp.get("Layoutlib.Revision");
            int llApi = propApi == null ? 0 : Integer.parseInt(propApi);
            int n = llRev = propRev == null ? 0 : Integer.parseInt(propRev);
            if (llApi > 0 && llRev >= 0) {
                layoutlibVersion = new SdkManager.LayoutlibVersion(llApi, llRev);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String err = LocalPlatformPkgInfo.checkPlatformContent(fileOp, platformFolder);
        if (err != null) {
            this.appendLoadError("%s", err);
            return null;
        }
        ISystemImage[] systemImages = this.getPlatformSystemImages(fileOp, platformFolder, apiVersion);
        PlatformTarget pt = new PlatformTarget(sdk.getLocation().getPath(), platformFolder.getAbsolutePath(), apiVersion, apiName, revision, layoutlibVersion, systemImages, platformProp, this.getOptionalLibraries(platformFolder), sdk.getLatestBuildTool());
        ArrayList<File> skins = new ArrayList<File>(PackageParserUtils.parseSkinFolder(pt.getFile(5), fileOp));
        for (ISystemImage systemImage : systemImages) {
            skins.addAll(Arrays.asList(systemImage.getSkins()));
        }
        pt.setSkins(skins.toArray(new File[skins.size()]));
        LocalPkgInfo samples = sdk.getPkgInfo(PkgType.PKG_SAMPLE, this.getDesc().getAndroidVersion());
        if (samples != null) {
            pt.setSamplesPath(samples.getLocalDir().getAbsolutePath());
        }
        if ((sources = sdk.getPkgInfo(PkgType.PKG_SOURCE, this.getDesc().getAndroidVersion())) != null) {
            pt.setSourcesPath(sources.getLocalDir().getAbsolutePath());
        }
        return pt;
    }

    @NonNull
    private ISystemImage[] getPlatformSystemImages(IFileOp fileOp, File platformDir, AndroidVersion apiVersion) {
        LocalPkgInfo[] sysImgInfos;
        TreeSet<SystemImage> found = new TreeSet<SystemImage>();
        TreeMultimap tagToAbiFound = TreeMultimap.create();
        for (LocalPkgInfo pkg : sysImgInfos = this.getLocalSdk().getPkgsInfos(PkgType.PKG_SYS_IMAGE)) {
            IPkgDesc d = pkg.getDesc();
            if (!(pkg instanceof LocalSysImgPkgInfo) || d.hasVendor() || !apiVersion.equals(d.getAndroidVersion())) continue;
            IdDisplay tag = d.getTag();
            String abi = d.getPath();
            if (tag == null || abi == null || tagToAbiFound.containsEntry((Object)tag, (Object)abi)) continue;
            found.add(((LocalSysImgPkgInfo)pkg).getSystemImage());
            tagToAbiFound.put((Object)tag, (Object)abi);
        }
        File imgDir = new File(platformDir, SdkConstants.OS_IMAGES_FOLDER);
        File[] files = fileOp.listFiles(imgDir);
        boolean useLegacy = true;
        boolean hasImgFiles = false;
        IdDisplay defaultTag = SystemImage.DEFAULT_TAG;
        for (File file : files) {
            if (fileOp.isDirectory(file)) {
                useLegacy = false;
                String abi = file.getName();
                if (tagToAbiFound.containsEntry((Object)defaultTag, (Object)abi)) continue;
                found.add(new SystemImage(file, ISystemImage.LocationType.IN_IMAGES_SUBFOLDER, defaultTag, abi, FileOp.EMPTY_FILE_ARRAY));
                tagToAbiFound.put((Object)defaultTag, (Object)abi);
                continue;
            }
            if (hasImgFiles || !fileOp.isFile(file) || !file.getName().endsWith(".img")) continue;
            hasImgFiles = true;
        }
        if (useLegacy && hasImgFiles && fileOp.isDirectory(imgDir) && !tagToAbiFound.containsEntry((Object)defaultTag, (Object)"armeabi")) {
            found.add(new SystemImage(imgDir, ISystemImage.LocationType.IN_LEGACY_FOLDER, defaultTag, "armeabi", FileOp.EMPTY_FILE_ARRAY));
        }
        return found.toArray(new ISystemImage[found.size()]);
    }

    private List<IAndroidTarget.OptionalLibrary> getOptionalLibraries(@NonNull File platformDir) {
        File optionalDir = new File(platformDir, "optional");
        if (!optionalDir.isDirectory()) {
            return Collections.emptyList();
        }
        File optionalJson = new File(optionalDir, "optional.json");
        if (!optionalJson.isFile()) {
            return Collections.emptyList();
        }
        return LocalPlatformPkgInfo.getLibsFromJson(optionalJson);
    }

    static List<IAndroidTarget.OptionalLibrary> getLibsFromJson(@NonNull File jsonFile) {
        Gson gson = new Gson();
        try {
            Type collectionType = new TypeToken<Collection<Library>>(){}.getType();
            Collection libs = (Collection)gson.fromJson((Reader)Files.newReader((File)jsonFile, (Charset)Charsets.UTF_8), collectionType);
            ArrayList optionalLibraries = Lists.newArrayListWithCapacity((int)libs.size());
            File rootFolder = jsonFile.getParentFile();
            for (Library lib : libs) {
                optionalLibraries.add(new OptionalLibraryImpl(lib.name, new File(rootFolder, lib.jar), lib.name, lib.manifest));
            }
            return optionalLibraries;
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
    }

    @NonNull
    private static String checkPlatformContent(IFileOp fileOp, @NonNull File platform) {
        for (String relativePath : sPlatformContentList) {
            File f = new File(platform, relativePath);
            if (fileOp.exists(f)) continue;
            return String.format("Ignoring platform '%1$s': %2$s is missing.", platform.getName(), relativePath);
        }
        return null;
    }

    public static class Library {
        String name;
        String jar;
        boolean manifest;
    }
}

