/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

class PackageParserUtils {
    PackageParserUtils() {
    }

    @Nullable
    public static FullRevision getPropertyFull(@Nullable Properties props, @NonNull String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        FullRevision rev = null;
        if (revStr != null) {
            try {
                rev = FullRevision.parseRevision(revStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return rev;
    }

    @Nullable
    public static MajorRevision getPropertyMajor(@Nullable Properties props, @NonNull String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        MajorRevision rev = null;
        if (revStr != null) {
            try {
                rev = MajorRevision.parseRevision(revStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return rev;
    }

    @Nullable
    public static NoPreviewRevision getPropertyNoPreview(@Nullable Properties props, @NonNull String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        NoPreviewRevision rev = null;
        if (revStr != null) {
            try {
                rev = NoPreviewRevision.parseRevision(revStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return rev;
    }

    @Nullable
    public static String getProperty(@Nullable Properties props, @NonNull String propKey, @Nullable String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        return props.getProperty(propKey, defaultValue);
    }

    @NonNull
    public static List<File> parseSkinFolder(@NonNull File skinRootFolder, @NonNull IFileOp fileOp) {
        if (fileOp.isDirectory(skinRootFolder)) {
            File[] files;
            ArrayList<File> skinList = new ArrayList<File>();
            for (File skinFolder : files = fileOp.listFiles(skinRootFolder)) {
                File layout;
                if (!fileOp.isDirectory(skinFolder) || !fileOp.isFile(layout = new File(skinFolder, "layout"))) continue;
                skinList.add(skinFolder);
            }
            Collections.sort(skinList);
            return skinList;
        }
        return Collections.emptyList();
    }
}

