/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.calendar.ui.basic;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

class MonthComboBoxRenderer
extends DefaultListCellRenderer {
    private TimeZone zone;
    private SimpleDateFormat dateFormat;

    public MonthComboBoxRenderer(Locale locale, TimeZone zone) {
        this.zone = zone;
        this.dateFormat = new SimpleDateFormat("MMMM", locale);
        this.dateFormat.setTimeZone(zone);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Date date = (Date)value;
        this.setText(this.dateFormat.format(date));
        return this;
    }

    public void setLocale(Locale locale) {
        this.dateFormat = new SimpleDateFormat("MMMM", locale);
        this.dateFormat.setTimeZone(this.zone);
    }

    public void setZone(TimeZone zone) {
        this.zone = zone;
        this.dateFormat.setTimeZone(zone);
    }
}

