/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;

public class NewFileTracker {
    private final Set<VirtualFile> newFiles = Collections.synchronizedSet(new THashSet());
    private static final NewFileTracker instance = new NewFileTracker();

    public static NewFileTracker getInstance() {
        return instance;
    }

    public boolean poll(VirtualFile file) {
        return this.newFiles.remove(file);
    }

    private NewFileTracker() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        virtualFileManager.addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(VirtualFileEvent event) {
                if (event.isFromRefresh()) {
                    return;
                }
                NewFileTracker.this.newFiles.add(event.getFile());
            }
        });
    }

    public void clear() {
        this.newFiles.clear();
    }
}

